/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/RawResults.h>
#include <so/private/RawResults.h>

so_RawResults *so_RawResults_new()
{
	so_RawResults *object = calloc(sizeof(so_RawResults), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_RawResults *so_RawResults_copy(so_RawResults *self)
{
	so_RawResults *dest = so_RawResults_new();
	if (dest) {
		if (self->num_DataFile) {
			dest->DataFile = calloc(self->num_DataFile * sizeof(so_Table *), 1);
			if (!dest->DataFile) {
				so_RawResults_free(dest);
				return NULL;
			}
			dest->num_DataFile = self->num_DataFile;
			for (int i = 0; i < self->num_DataFile; i++) {
				dest->DataFile[i] = so_Table_copy(self->DataFile[i]);
				if (!dest->DataFile[i]) {
					so_RawResults_free(dest);
					return NULL;
				}
			}
		}
		if (self->num_GraphicsFile) {
			dest->GraphicsFile = calloc(self->num_GraphicsFile * sizeof(so_ExternalFile *), 1);
			if (!dest->GraphicsFile) {
				so_RawResults_free(dest);
				return NULL;
			}
			dest->num_GraphicsFile = self->num_GraphicsFile;
			for (int i = 0; i < self->num_GraphicsFile; i++) {
				dest->GraphicsFile[i] = so_ExternalFile_copy(self->GraphicsFile[i]);
				if (!dest->GraphicsFile[i]) {
					so_RawResults_free(dest);
					return NULL;
				}
			}
		}
	}

	return dest;
}

void so_RawResults_free(so_RawResults *self)
{
	if (self) {
		for(int i = 0; i < self->num_DataFile; i++) {
			so_Table_unref(self->DataFile[i]);
		}
		free(self->DataFile);
		for(int i = 0; i < self->num_GraphicsFile; i++) {
			so_ExternalFile_unref(self->GraphicsFile[i]);
		}
		free(self->GraphicsFile);
		free(self);
	}
}

void so_RawResults_ref(so_RawResults *self)
{
	self->reference_count++;
}

void so_RawResults_unref(so_RawResults *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_RawResults_free(self);
		}
	}
}

so_Table *so_RawResults_get_DataFile(so_RawResults *self, int number)
{
	return self->DataFile[number];
}

so_ExternalFile *so_RawResults_get_GraphicsFile(so_RawResults *self, int number)
{
	return self->GraphicsFile[number];
}

int so_RawResults_get_number_of_DataFile(so_RawResults *self)
{
	return self->num_DataFile;
}

int so_RawResults_get_number_of_GraphicsFile(so_RawResults *self)
{
	return self->num_GraphicsFile;
}

so_Table *so_RawResults_create_DataFile(so_RawResults *self)
{
	so_Table *obj = so_Table_new("DataFile");
	if (obj) {
		so_Table **newblock = realloc(self->DataFile, (self->num_DataFile + 1) * sizeof(so_Table *));
		if (newblock) {
			self->DataFile = newblock;
			self->DataFile[self->num_DataFile] = obj;
			self->num_DataFile++;
		} else {
			so_Table_free(obj);
			obj = NULL;
		}
	}
	return obj;
}

so_ExternalFile *so_RawResults_create_GraphicsFile(so_RawResults *self)
{
	so_ExternalFile *obj = so_ExternalFile_new("GraphicsFile");
	if (obj) {
		so_ExternalFile **newblock = realloc(self->GraphicsFile, (self->num_GraphicsFile + 1) * sizeof(so_ExternalFile *));
		if (newblock) {
			self->GraphicsFile = newblock;
			self->GraphicsFile[self->num_GraphicsFile] = obj;
			self->num_GraphicsFile++;
		} else {
			so_ExternalFile_free(obj);
			obj = NULL;
		}
	}
	return obj;
}

int so_RawResults_add_DataFile(so_RawResults *self, so_Table *child)
{
	so_Table **new_array = realloc(self->DataFile, (self->num_DataFile + 1) * sizeof(so_Table *));
	if (!new_array) {
		return 1;
	}
	self->DataFile = new_array;
	self->DataFile[self->num_DataFile] = child;
	self->num_DataFile++;
	return 0;
}

int so_RawResults_remove_DataFile(so_RawResults *self, int index)
{
	int size = self->num_DataFile;
	if (index >= size) {
		return 0;
	}
	if (size == 1) {
		free(self->DataFile);
		self->DataFile = NULL;
		return 0;
	}
	so_Table *final = self->DataFile[size - 1];
	so_Table *remove = self->DataFile[index];
	so_Table **new_array = realloc(self->DataFile, (self->num_DataFile - 1) * sizeof(so_Table *));
	if (!new_array) {
		return 1;
	}
	self->num_DataFile--;
	if (final == remove) {
		return 0;
	}
	for (int i = index; i < size - 3; i++) {
		self->DataFile[i] = self->DataFile[i + 1];
	}
	self->DataFile[size - 2] = final;
	so_Table_unref(remove);
	return 0;
}

int so_RawResults_add_GraphicsFile(so_RawResults *self, so_ExternalFile *child)
{
	so_ExternalFile **new_array = realloc(self->GraphicsFile, (self->num_GraphicsFile + 1) * sizeof(so_ExternalFile *));
	if (!new_array) {
		return 1;
	}
	self->GraphicsFile = new_array;
	self->GraphicsFile[self->num_GraphicsFile] = child;
	self->num_GraphicsFile++;
	return 0;
}

int so_RawResults_remove_GraphicsFile(so_RawResults *self, int index)
{
	int size = self->num_GraphicsFile;
	if (index >= size) {
		return 0;
	}
	if (size == 1) {
		free(self->GraphicsFile);
		self->GraphicsFile = NULL;
		return 0;
	}
	so_ExternalFile *final = self->GraphicsFile[size - 1];
	so_ExternalFile *remove = self->GraphicsFile[index];
	so_ExternalFile **new_array = realloc(self->GraphicsFile, (self->num_GraphicsFile - 1) * sizeof(so_ExternalFile *));
	if (!new_array) {
		return 1;
	}
	self->num_GraphicsFile--;
	if (final == remove) {
		return 0;
	}
	for (int i = index; i < size - 3; i++) {
		self->GraphicsFile[i] = self->GraphicsFile[i + 1];
	}
	self->GraphicsFile[size - 2] = final;
	so_ExternalFile_unref(remove);
	return 0;
}

int so_RawResults_xml(so_RawResults *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->DataFile || self->GraphicsFile) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "RawResults");
		if (rc < 0) return 1;
		if (self->DataFile) {
			for (int i = 0; i < self->num_DataFile; i++) {
				rc = so_Table_xml(self->DataFile[i], writer, "DataFile");
				if (rc != 0) return 1;
			}
		}
		if (self->GraphicsFile) {
			for (int i = 0; i < self->num_GraphicsFile; i++) {
				rc = so_ExternalFile_xml(self->GraphicsFile[i], writer, "GraphicsFile");
				if (rc != 0) return 1;
			}
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_RawResults_start_element(so_RawResults *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_DataFile) {
		int fail = so_Table_start_element(self->DataFile[self->num_DataFile - 1], localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_GraphicsFile) {
		int fail = so_ExternalFile_start_element(self->GraphicsFile[self->num_GraphicsFile - 1], localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "DataFile") == 0) {
		so_Table *DataFile = so_RawResults_create_DataFile(self);
		if (!DataFile) {
			return 1;
		}
		self->in_DataFile = 1;
	} else if (strcmp(localname, "GraphicsFile") == 0) {
		so_ExternalFile *GraphicsFile = so_ExternalFile_new("GraphicsFile");
		if (!GraphicsFile) {
			return 1;
		}
		int fail = so_ExternalFile_init_attributes(GraphicsFile, nb_attributes, attributes);
		if (fail) {
			so_ExternalFile_free(GraphicsFile);
			return 1;
		}
		fail = so_RawResults_add_GraphicsFile(self, GraphicsFile);
		if (fail) {
			so_ExternalFile_free(GraphicsFile);
			return 1;
		}
		self->in_GraphicsFile = 1;
	}
	return 0;
}

void so_RawResults_end_element(so_RawResults *self, const char *localname)
{
	if (strcmp(localname, "DataFile") == 0 && self->in_DataFile) {
		self->in_DataFile = 0;
	} else if (strcmp(localname, "GraphicsFile") == 0 && self->in_GraphicsFile) {
		self->in_GraphicsFile = 0;
	} else if (self->in_DataFile) {
		so_Table_end_element(self->DataFile[self->num_DataFile - 1], localname);
	} else if (self->in_GraphicsFile) {
		so_ExternalFile_end_element(self->GraphicsFile[self->num_GraphicsFile - 1], localname);
	}
}

int so_RawResults_characters(so_RawResults *self, const char *ch, int len)
{
	if (self->in_DataFile) {
		int fail = so_Table_characters(self->DataFile[self->num_DataFile - 1], ch, len);
		if (fail) return 1;
	} else if (self->in_GraphicsFile) {
		int fail = so_ExternalFile_characters(self->GraphicsFile[self->num_GraphicsFile - 1], ch, len);
		if (fail) return 1;
	}
	return 0;
}
