/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/Estimation.h>
#include <so/private/Estimation.h>

so_Estimation *so_Estimation_new()
{
	so_Estimation *object = calloc(sizeof(so_Estimation), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_Estimation *so_Estimation_copy(so_Estimation *self)
{
	so_Estimation *dest = so_Estimation_new();
	if (dest) {
		if (self->PopulationEstimates) {
			dest->PopulationEstimates = so_PopulationEstimates_copy(self->PopulationEstimates);
			if (!dest->PopulationEstimates) {
				so_Estimation_free(dest);
				return NULL;
			}
		}
		if (self->PrecisionPopulationEstimates) {
			dest->PrecisionPopulationEstimates = so_PrecisionPopulationEstimates_copy(self->PrecisionPopulationEstimates);
			if (!dest->PrecisionPopulationEstimates) {
				so_Estimation_free(dest);
				return NULL;
			}
		}
		if (self->IndividualEstimates) {
			dest->IndividualEstimates = so_IndividualEstimates_copy(self->IndividualEstimates);
			if (!dest->IndividualEstimates) {
				so_Estimation_free(dest);
				return NULL;
			}
		}
		if (self->PrecisionIndividualEstimates) {
			dest->PrecisionIndividualEstimates = so_PrecisionIndividualEstimates_copy(self->PrecisionIndividualEstimates);
			if (!dest->PrecisionIndividualEstimates) {
				so_Estimation_free(dest);
				return NULL;
			}
		}
		if (self->Residuals) {
			dest->Residuals = so_Residuals_copy(self->Residuals);
			if (!dest->Residuals) {
				so_Estimation_free(dest);
				return NULL;
			}
		}
		if (self->Predictions) {
			dest->Predictions = so_Table_copy(self->Predictions);
			if (!dest->Predictions) {
				so_Estimation_free(dest);
				return NULL;
			}
		}
		if (self->OFMeasures) {
			dest->OFMeasures = so_OFMeasures_copy(self->OFMeasures);
			if (!dest->OFMeasures) {
				so_Estimation_free(dest);
				return NULL;
			}
		}
		if (self->TargetToolMessages) {
			dest->TargetToolMessages = so_TargetToolMessages_copy(self->TargetToolMessages);
			if (!dest->TargetToolMessages) {
				so_Estimation_free(dest);
				return NULL;
			}
		}
	}

	return dest;
}

void so_Estimation_free(so_Estimation *self)
{
	if (self) {
		so_PopulationEstimates_unref(self->PopulationEstimates);
		so_PrecisionPopulationEstimates_unref(self->PrecisionPopulationEstimates);
		so_IndividualEstimates_unref(self->IndividualEstimates);
		so_PrecisionIndividualEstimates_unref(self->PrecisionIndividualEstimates);
		so_Residuals_unref(self->Residuals);
		so_Table_unref(self->Predictions);
		so_OFMeasures_unref(self->OFMeasures);
		so_TargetToolMessages_unref(self->TargetToolMessages);
		free(self);
	}
}

void so_Estimation_ref(so_Estimation *self)
{
	self->reference_count++;
}

void so_Estimation_unref(so_Estimation *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_Estimation_free(self);
		}
	}
}

so_PopulationEstimates *so_Estimation_get_PopulationEstimates(so_Estimation *self)
{
	return self->PopulationEstimates;
}

so_PrecisionPopulationEstimates *so_Estimation_get_PrecisionPopulationEstimates(so_Estimation *self)
{
	return self->PrecisionPopulationEstimates;
}

so_IndividualEstimates *so_Estimation_get_IndividualEstimates(so_Estimation *self)
{
	return self->IndividualEstimates;
}

so_PrecisionIndividualEstimates *so_Estimation_get_PrecisionIndividualEstimates(so_Estimation *self)
{
	return self->PrecisionIndividualEstimates;
}

so_Residuals *so_Estimation_get_Residuals(so_Estimation *self)
{
	return self->Residuals;
}

so_Table *so_Estimation_get_Predictions(so_Estimation *self)
{
	return self->Predictions;
}

so_OFMeasures *so_Estimation_get_OFMeasures(so_Estimation *self)
{
	return self->OFMeasures;
}

so_TargetToolMessages *so_Estimation_get_TargetToolMessages(so_Estimation *self)
{
	return self->TargetToolMessages;
}

void so_Estimation_set_PopulationEstimates(so_Estimation *self, so_PopulationEstimates *value)
{
	so_PopulationEstimates_unref(self->PopulationEstimates);
	self->PopulationEstimates = value;
}

void so_Estimation_set_PrecisionPopulationEstimates(so_Estimation *self, so_PrecisionPopulationEstimates *value)
{
	so_PrecisionPopulationEstimates_unref(self->PrecisionPopulationEstimates);
	self->PrecisionPopulationEstimates = value;
}

void so_Estimation_set_IndividualEstimates(so_Estimation *self, so_IndividualEstimates *value)
{
	so_IndividualEstimates_unref(self->IndividualEstimates);
	self->IndividualEstimates = value;
}

void so_Estimation_set_PrecisionIndividualEstimates(so_Estimation *self, so_PrecisionIndividualEstimates *value)
{
	so_PrecisionIndividualEstimates_unref(self->PrecisionIndividualEstimates);
	self->PrecisionIndividualEstimates = value;
}

void so_Estimation_set_Residuals(so_Estimation *self, so_Residuals *value)
{
	so_Residuals_unref(self->Residuals);
	self->Residuals = value;
}

void so_Estimation_set_Predictions(so_Estimation *self, so_Table *value)
{
	so_Table_unref(self->Predictions);
	self->Predictions = value;
}

void so_Estimation_set_OFMeasures(so_Estimation *self, so_OFMeasures *value)
{
	so_OFMeasures_unref(self->OFMeasures);
	self->OFMeasures = value;
}

void so_Estimation_set_TargetToolMessages(so_Estimation *self, so_TargetToolMessages *value)
{
	so_TargetToolMessages_unref(self->TargetToolMessages);
	self->TargetToolMessages = value;
}

so_PopulationEstimates *so_Estimation_create_PopulationEstimates(so_Estimation *self)
{
	so_PopulationEstimates *obj = so_PopulationEstimates_new();
	if (obj) {
		self->PopulationEstimates = obj;
	}
	return obj;
}

so_PrecisionPopulationEstimates *so_Estimation_create_PrecisionPopulationEstimates(so_Estimation *self)
{
	so_PrecisionPopulationEstimates *obj = so_PrecisionPopulationEstimates_new();
	if (obj) {
		self->PrecisionPopulationEstimates = obj;
	}
	return obj;
}

so_IndividualEstimates *so_Estimation_create_IndividualEstimates(so_Estimation *self)
{
	so_IndividualEstimates *obj = so_IndividualEstimates_new();
	if (obj) {
		self->IndividualEstimates = obj;
	}
	return obj;
}

so_PrecisionIndividualEstimates *so_Estimation_create_PrecisionIndividualEstimates(so_Estimation *self)
{
	so_PrecisionIndividualEstimates *obj = so_PrecisionIndividualEstimates_new();
	if (obj) {
		self->PrecisionIndividualEstimates = obj;
	}
	return obj;
}

so_Residuals *so_Estimation_create_Residuals(so_Estimation *self)
{
	so_Residuals *obj = so_Residuals_new();
	if (obj) {
		self->Residuals = obj;
	}
	return obj;
}

so_Table *so_Estimation_create_Predictions(so_Estimation *self)
{
	so_Table *obj = so_Table_new("Predictions");
	if (obj) {
		self->Predictions = obj;
	}
	return obj;
}

so_OFMeasures *so_Estimation_create_OFMeasures(so_Estimation *self)
{
	so_OFMeasures *obj = so_OFMeasures_new();
	if (obj) {
		self->OFMeasures = obj;
	}
	return obj;
}

so_TargetToolMessages *so_Estimation_create_TargetToolMessages(so_Estimation *self)
{
	so_TargetToolMessages *obj = so_TargetToolMessages_new();
	if (obj) {
		self->TargetToolMessages = obj;
	}
	return obj;
}

int so_Estimation_xml(so_Estimation *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->PopulationEstimates || self->PrecisionPopulationEstimates || self->IndividualEstimates || self->PrecisionIndividualEstimates || self->Residuals || self->Predictions || self->OFMeasures || self->TargetToolMessages) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "Estimation");
		if (rc < 0) return 1;
		if (self->PopulationEstimates) {
			rc = so_PopulationEstimates_xml(self->PopulationEstimates, writer);
			if (rc != 0) return rc;
		}
		if (self->PrecisionPopulationEstimates) {
			rc = so_PrecisionPopulationEstimates_xml(self->PrecisionPopulationEstimates, writer);
			if (rc != 0) return rc;
		}
		if (self->IndividualEstimates) {
			rc = so_IndividualEstimates_xml(self->IndividualEstimates, writer);
			if (rc != 0) return rc;
		}
		if (self->PrecisionIndividualEstimates) {
			rc = so_PrecisionIndividualEstimates_xml(self->PrecisionIndividualEstimates, writer);
			if (rc != 0) return rc;
		}
		if (self->Residuals) {
			rc = so_Residuals_xml(self->Residuals, writer);
			if (rc != 0) return rc;
		}
		if (self->Predictions) {
			rc = so_Table_xml(self->Predictions, writer, "Predictions");
			if (rc != 0) return rc;
		}
		if (self->OFMeasures) {
			rc = so_OFMeasures_xml(self->OFMeasures, writer);
			if (rc != 0) return rc;
		}
		if (self->TargetToolMessages) {
			rc = so_TargetToolMessages_xml(self->TargetToolMessages, writer);
			if (rc != 0) return rc;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_Estimation_start_element(so_Estimation *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_PopulationEstimates) {
		int fail = so_PopulationEstimates_start_element(self->PopulationEstimates, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_PrecisionPopulationEstimates) {
		int fail = so_PrecisionPopulationEstimates_start_element(self->PrecisionPopulationEstimates, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_IndividualEstimates) {
		int fail = so_IndividualEstimates_start_element(self->IndividualEstimates, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_PrecisionIndividualEstimates) {
		int fail = so_PrecisionIndividualEstimates_start_element(self->PrecisionIndividualEstimates, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_Residuals) {
		int fail = so_Residuals_start_element(self->Residuals, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_Predictions) {
		int fail = so_Table_start_element(self->Predictions, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_OFMeasures) {
		int fail = so_OFMeasures_start_element(self->OFMeasures, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_TargetToolMessages) {
		int fail = so_TargetToolMessages_start_element(self->TargetToolMessages, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "PopulationEstimates") == 0) {
		so_PopulationEstimates *PopulationEstimates = so_Estimation_create_PopulationEstimates(self);
		if (!PopulationEstimates) {
			return 1;
		}
		self->in_PopulationEstimates = 1;
	} else if (strcmp(localname, "PrecisionPopulationEstimates") == 0) {
		so_PrecisionPopulationEstimates *PrecisionPopulationEstimates = so_Estimation_create_PrecisionPopulationEstimates(self);
		if (!PrecisionPopulationEstimates) {
			return 1;
		}
		self->in_PrecisionPopulationEstimates = 1;
	} else if (strcmp(localname, "IndividualEstimates") == 0) {
		so_IndividualEstimates *IndividualEstimates = so_Estimation_create_IndividualEstimates(self);
		if (!IndividualEstimates) {
			return 1;
		}
		self->in_IndividualEstimates = 1;
	} else if (strcmp(localname, "PrecisionIndividualEstimates") == 0) {
		so_PrecisionIndividualEstimates *PrecisionIndividualEstimates = so_Estimation_create_PrecisionIndividualEstimates(self);
		if (!PrecisionIndividualEstimates) {
			return 1;
		}
		self->in_PrecisionIndividualEstimates = 1;
	} else if (strcmp(localname, "Residuals") == 0) {
		so_Residuals *Residuals = so_Estimation_create_Residuals(self);
		if (!Residuals) {
			return 1;
		}
		self->in_Residuals = 1;
	} else if (strcmp(localname, "Predictions") == 0) {
		so_Table *Predictions = so_Estimation_create_Predictions(self);
		if (!Predictions) {
			return 1;
		}
		self->in_Predictions = 1;
	} else if (strcmp(localname, "OFMeasures") == 0) {
		so_OFMeasures *OFMeasures = so_Estimation_create_OFMeasures(self);
		if (!OFMeasures) {
			return 1;
		}
		self->in_OFMeasures = 1;
	} else if (strcmp(localname, "TargetToolMessages") == 0) {
		so_TargetToolMessages *TargetToolMessages = so_Estimation_create_TargetToolMessages(self);
		if (!TargetToolMessages) {
			return 1;
		}
		self->in_TargetToolMessages = 1;
	}
	return 0;
}

void so_Estimation_end_element(so_Estimation *self, const char *localname)
{
	if (strcmp(localname, "PopulationEstimates") == 0 && self->in_PopulationEstimates) {
		self->in_PopulationEstimates = 0;
	} else if (strcmp(localname, "PrecisionPopulationEstimates") == 0 && self->in_PrecisionPopulationEstimates) {
		self->in_PrecisionPopulationEstimates = 0;
	} else if (strcmp(localname, "IndividualEstimates") == 0 && self->in_IndividualEstimates) {
		self->in_IndividualEstimates = 0;
	} else if (strcmp(localname, "PrecisionIndividualEstimates") == 0 && self->in_PrecisionIndividualEstimates) {
		self->in_PrecisionIndividualEstimates = 0;
	} else if (strcmp(localname, "Residuals") == 0 && self->in_Residuals) {
		self->in_Residuals = 0;
	} else if (strcmp(localname, "Predictions") == 0 && self->in_Predictions) {
		self->in_Predictions = 0;
	} else if (strcmp(localname, "OFMeasures") == 0 && self->in_OFMeasures) {
		self->in_OFMeasures = 0;
	} else if (strcmp(localname, "TargetToolMessages") == 0 && self->in_TargetToolMessages) {
		self->in_TargetToolMessages = 0;
	} else if (self->in_PopulationEstimates) {
		so_PopulationEstimates_end_element(self->PopulationEstimates, localname);
	} else if (self->in_PrecisionPopulationEstimates) {
		so_PrecisionPopulationEstimates_end_element(self->PrecisionPopulationEstimates, localname);
	} else if (self->in_IndividualEstimates) {
		so_IndividualEstimates_end_element(self->IndividualEstimates, localname);
	} else if (self->in_PrecisionIndividualEstimates) {
		so_PrecisionIndividualEstimates_end_element(self->PrecisionIndividualEstimates, localname);
	} else if (self->in_Residuals) {
		so_Residuals_end_element(self->Residuals, localname);
	} else if (self->in_Predictions) {
		so_Table_end_element(self->Predictions, localname);
	} else if (self->in_OFMeasures) {
		so_OFMeasures_end_element(self->OFMeasures, localname);
	} else if (self->in_TargetToolMessages) {
		so_TargetToolMessages_end_element(self->TargetToolMessages, localname);
	}
}

int so_Estimation_characters(so_Estimation *self, const char *ch, int len)
{
	if (self->in_PopulationEstimates) {
		int fail = so_PopulationEstimates_characters(self->PopulationEstimates, ch, len);
		if (fail) return 1;
	} else if (self->in_PrecisionPopulationEstimates) {
		int fail = so_PrecisionPopulationEstimates_characters(self->PrecisionPopulationEstimates, ch, len);
		if (fail) return 1;
	} else if (self->in_IndividualEstimates) {
		int fail = so_IndividualEstimates_characters(self->IndividualEstimates, ch, len);
		if (fail) return 1;
	} else if (self->in_PrecisionIndividualEstimates) {
		int fail = so_PrecisionIndividualEstimates_characters(self->PrecisionIndividualEstimates, ch, len);
		if (fail) return 1;
	} else if (self->in_Residuals) {
		int fail = so_Residuals_characters(self->Residuals, ch, len);
		if (fail) return 1;
	} else if (self->in_Predictions) {
		int fail = so_Table_characters(self->Predictions, ch, len);
		if (fail) return 1;
	} else if (self->in_OFMeasures) {
		int fail = so_OFMeasures_characters(self->OFMeasures, ch, len);
		if (fail) return 1;
	} else if (self->in_TargetToolMessages) {
		int fail = so_TargetToolMessages_characters(self->TargetToolMessages, ch, len);
		if (fail) return 1;
	}
	return 0;
}
