% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_hexametrics.r
\name{grid_hexametrics}
\alias{grid_hexametrics}
\title{Compute metrics for hexagonal cells}
\usage{
grid_hexametrics(.las, func, res = 20, splitlines = FALSE, debug = FALSE)
}
\arguments{
\item{.las}{An object of class \code{LAS}}

\item{func}{the function to be applied to each hexagonal cell}

\item{res}{numeric. The inscribed circle radius of a hexagon. Default = 20.}

\item{splitlines}{logical. If TRUE the algorithm will compute the metrics for each
flightline individually. It returns the same cells several times in overlaps.}

\item{debug}{logical. If you encounter a non trivial error try \code{debug = TRUE}.}
}
\value{
It returns a \code{data.table} containing the metrics for each hexagonal cell. The table
has the class "lashexametrics" enabling easy plotting.
}
\description{
Computes a series of descriptive statistics for a LiDAR dataset within hexagonal cells
from a hexagonal grid pattern. This function is identical to \link{grid_metrics} or
\link{grid_metrics3d} or \link{tree_metrics} but with hexagonal cells instead of classical
square pixels. Please refer to \link{grid_metrics} for more information.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

# Maximum elevation with a resolution of 4 m
grid_hexametrics(lidar, max(Z), 4) \%>\% plot

# Mean height with a resolution of 20 m
grid_hexametrics(lidar, mean(Z)) \%>\% plot

# Define your own new metrics
myMetrics = function(z, i)
{
  metrics = list(
     zwimean = sum(z*i)/sum(i), # Mean elevation weighted by intensities
     zimean  = mean(z*i),       # Mean products of z by intensity
     zsqmean = sqrt(mean(z^2))  # Quadratic mean
   )

   return(metrics)
}

metrics = grid_hexametrics(lidar, myMetrics(Z, Intensity), 10)

plot(metrics, "zwimean")
plot(metrics, "zimean")
plot(metrics, "zsqmean")
#etc.
}
