% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasground.r
\name{lasground}
\alias{lasground}
\alias{lasground_pmf}
\title{Classify points as ground or not ground}
\usage{
lasground(las, algorithm, ...)

lasground_pmf(las, ws, th, last_returns = TRUE)
}
\arguments{
\item{las}{a LAS object.}

\item{algorithm}{character. The name of an algorithm. Currently \code{"pmf"} is supported
(see related sections).}

\item{...}{parameters for the algorithms. These depend on the algorithm used (see details
of the algorithms).}

\item{ws}{numeric. Sequence of windows sizes to be used in filtering ground returns.
The values must be positive and in the same units as the point cloud (usually meters, occasionally
feet).}

\item{th}{numeric. Sequence of threshold heights above the parameterized ground surface to be
considered a ground return. The values must be positive and in the same units as the point cloud.}

\item{last_returns}{logical. The algorithm will use only the last returns (including the first returns
in the cases of single return) to run the algorithm. If FALSE all the returns are used. If the fields
\code{'ReturnNumber'} or \code{'NumberOfReturns'} are not specified \code{'last_returns'} is turned
to \code{FALSE} automatically.}
}
\value{
Nothing. The original LAS object is updated by reference. In the 'Classification'
column a value of 2 denotes 'ground' according to LAS specifications.
}
\description{
Implements algorithms for segmentation of ground points. The function updates the field
\code{Classification} of the LAS input object. The points classified as 'ground' are
assigned a value of 2 according to las specifications (See the ASPRS documentation for the
\href{http://www.asprs.org/a/society/committees/standards/LAS_1_4_r13.pdf}{LAS file format}).
}
\section{Progressive morphological filter (PMF)}{


This method is an implementation of the Zhang et al. (2003) algorithm (see reference).
Note that this is not a strict implementation of Zhang et al. This algorithm works at the point
cloud level without any rasterization process. The morphological operator is applied on
the point cloud, not on a raster. Also, Zhang et al. proposed some formulas (eq. 4, 5 and 7)
to compute the sequence of windows sizes and thresholds. Here, these parameters are free
and specified by the user. The function \link{util_makeZhangParam} enables computation
of the parameters according to the original paper.
}

\examples{
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
las = readLAS(LASfile, select = "xyzRN")

ws = seq(3,12, 3)
th = seq(0.1, 1.5, length.out = length(ws))

lasground(las, "pmf", ws, th)

plot(las, color = "Classification")
}
\references{
Zhang, K., Chen, S. C., Whitman, D., Shyu, M. L., Yan, J., & Zhang, C. (2003). A progressive
morphological filter for removing nonground measurements from airborne LIDAR data. IEEE
Transactions on Geoscience and Remote Sensing, 41(4 PART I), 872–882. http:#doi.org/10.1109/TGRS.2003.810682.
}
