% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-dec.r
\name{homogenize}
\alias{homogenize}
\title{Point Cloud Decimation Algorithm}
\usage{
homogenize(density, res = 5, use_pulse = FALSE)
}
\arguments{
\item{density}{numeric. The desired output density.}

\item{res}{numeric. The resolution of the grid used to filter the point cloud}

\item{use_pulse}{logical. Decimate by removing random pulses instead of random points (requires running
\link{laspulse} first)}
}
\description{
This function is made to be used in \link{lasfilterdecimate}. It implements an algorithm that
creates a grid with a given resolution and filters the point cloud by randomly selecting some
points in each cell. It is designed to produce point clouds that have uniform densities throughout
the coverage area. For each cell, the proportion of points or pulses that will be retained is computed
using the actual local density and the desired density. If the desired density is greater than the actual
density it returns an unchanged set of points (it cannot increase the density). The cell size must be
large enough to compute a coherent local density. For example in a 2 points/m^2 point cloud, 25 square
meters would be feasible; however 1 square meter cells would not be feasible because density does
not have meaning at this scale.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las = readLAS(LASfile, select = "xyz")

# Select points randomly to reach an homogeneous density of 1
thinned = lasfilterdecimate(las, homogenize(1,5))
plot(grid_density(thinned))
}
\seealso{
Other point cloud decimation algorithms: 
\code{\link{highest}()},
\code{\link{random}()}
}
\concept{point cloud decimation algorithms}
