% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexbin_metrics.R
\name{hexbin_metrics}
\alias{hexbin_metrics}
\title{Area-Based Approach in hexagonal cells.}
\usage{
hexbin_metrics(las, func, res = 20)
}
\arguments{
\item{las}{An object of class \code{LAS}.}

\item{func}{formula. An expression to be applied to each hexagonal cell.}

\item{res}{numeric. To be consistent with \link{grid_metrics}, the square of \code{res} give the area
of the hexagonal cells, like in \code{grid_metrics}. The difference being the fact that for square pixels this
is obvious. Here \code{res = 20} gives 400-square-meter hexagonal cells.}
}
\value{
A \link[hexbin:hexbin-class]{hexbin} object from package \code{hexbin} or a \code{list} of
\code{hexbin} objects if several metrics are returned.
}
\description{
Computes a series of descriptive statistics for a LiDAR dataset within hexagonal cells.
This function is identical to \link{grid_metrics} but with hexagonal cells instead of
square pixels. After all, we conduct circular plot inventories and we map models on pixel-based maps.
\code{hexbin_metrics} provides the opportunity to test something else. Refer to \link{grid_metrics}
for more information.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

col = grDevices::colorRampPalette(c("blue", "cyan2", "yellow", "red"))

# Maximum elevation with a resolution of 8 m
hm = hexbin_metrics(lidar, ~max(Z), 8)
hexbin::plot(hm, colramp = col, main = "Max Z")

# Mean height with a resolution of 20 m
hm = hexbin_metrics(lidar, ~mean(Z), 20)
hexbin::plot(hm, colramp = col, main = "Mean Z")

# Define your own new metrics
myMetrics = function(z, i)
{
  metrics = list(
    zwimean = sum(z*i)/sum(i), # Mean elevation weighted by intensities
    zimean  = mean(z*i),       # Mean products of z by intensity
  zsqmean = sqrt(mean(z^2))    # Quadratic mean
  )

  return(metrics)
}

metrics = hexbin_metrics(lidar, ~myMetrics(Z, Intensity), 10)

hexbin::plot(metrics$zwimean, colramp = col, main = "zwimean")
hexbin::plot(metrics$zimean, colramp = col, main = "zimean")
hexbin::plot(metrics$zsqmean, colramp = col, main = "zsqmean")
}
\seealso{
Other metrics: 
\code{\link{cloud_metrics}()},
\code{\link{grid_metrics}()},
\code{\link{point_metrics}()},
\code{\link{tree_metrics}()},
\code{\link{voxel_metrics}()}
}
\concept{metrics}
