% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot,LAS,missing-method}
\alias{plot,LAScatalog,missing-method}
\alias{plot,LASheader,missing-method}
\title{Plot a LAS* object}
\usage{
plot(x, y, ...)

\S4method{plot}{LAS,missing}(
  x,
  y,
  color = "Z",
  colorPalette = "auto",
  bg = "black",
  trim = Inf,
  backend = c("rgl", "pcv"),
  clear_artifacts = TRUE,
  nbits = 16,
  axis = FALSE,
  legend = FALSE,
  add = FALSE,
  ...
)

\S4method{plot}{LAScatalog,missing}(x, y, mapview = FALSE, chunk_pattern = FALSE, overlaps = FALSE, ...)

\S4method{plot}{LASheader,missing}(x, y, mapview = FALSE, ...)
}
\arguments{
\item{x}{A \code{LAS*} object}

\item{y}{Unused (inherited from R base)}

\item{...}{Will be passed to \link[rgl:points3d]{points3d} (LAS) or \link[graphics:plot]{plot}
if \code{mapview = FALSE} or to \link[mapview:mapView]{mapview} if \code{mapview = TRUE} (LAScatalog).}

\item{color}{characters. The attribute used to color the point cloud. Default is Z coordinates. RGB
is an allowed string even if it refers to three attributes simultaneously.}

\item{colorPalette}{characters. A vector of colors such as that generated by heat.colors,
topo.colors, terrain.colors or similar functions. Default is \code{"auto"} providing an automatic
coloring depending on the argument \code{color}}

\item{bg}{The color for the background. Default is black.}

\item{trim}{numeric. Enables trimming of values when outliers break the color palette range.
Every point with a value higher than \code{trim} will be plotted with the highest color.}

\item{backend}{character. Can be \code{"rgl"} or \code{"pcv"}. If \code{"rgl"} is chosen
the display relies on the \code{rgl} package. If \code{"pcv"} is chosen it relies on the
\code{PointCloudViewer} package, which is much more efficient and can handle million of points
using less memory. \code{PointCloudViewer} is not available on CRAN yet and should
be installed from github (see. \url{https://github.com/Jean-Romain/PointCloudViewer}).}

\item{clear_artifacts}{logical. It is a known and documented issue that the 3D visualisation with
\code{rgl} displays artifacts. The points look aligned and/or regularly spaced in some view angles.
This is because \code{rgl} computes with single precision \code{float}. To fix that the point
cloud is shifted to (0,0) to reduce the number of digits needed to represent its coordinates.
The drawback is that the point cloud is not plotted at its actual coordinates.}

\item{nbits}{integer. If \code{color = RGB} it assumes that RGB colors are coded on 16 bits as described
in the LAS format specification. However, this is not always respected. If the colors are stored
on 8 bits set this parameter to 8.}

\item{axis}{logical. Display axis on XYZ coordinates.}

\item{legend}{logical. Display a gradient color legend.}

\item{add}{If \code{FALSE} normal behavior otherwise must be the output of a prior plot function
to enable the alignment of a second point cloud.}

\item{mapview}{logical. If \code{FALSE} the catalog is displayed in a regular plot from R base.}

\item{chunk_pattern}{logical. Display the current chunk pattern used to process the catalog.}

\item{overlaps}{logical. Highlight the overlaps between files.}
}
\description{
Plot displays a 3D interactive windows-based on rgl for \link{LAS} objects\cr\cr
Plot displays an interactive view for \link[lidR:LAScatalog-class]{LAScatalog} objects with pan and
zoom capabilities based on \link[mapview:mapview-package]{mapview}. If the coordinate reference
system (CRS) of the \code{LAScatalog} is non empty, the plot can be displayed on top of base maps
(satellite data, elevation, street, and so on).\cr\cr
Plot displays a \link[lidR:LASheader-class]{LASheader} object exactly like it displays a LAScatalog
object.
}
\examples{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las <- readLAS(LASfile)

plot(las)
plot(las, color = "Intensity")

# If outliers break the color range, use the trim parameter
plot(las, color = "Intensity", trim = 150)

plot(las, color = "Classification")

# This dataset is already tree segmented
plot(las, color = "treeID")

# single file catalog using data provided in lidR
ctg = readLAScatalog(LASfile)
plot(ctg)

}
