% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_bbox.R
\name{st_bbox}
\alias{st_bbox}
\alias{st_bbox.LAS}
\alias{st_bbox.LASheader}
\alias{st_bbox.LAScatalog}
\alias{st_bbox.LAScluster}
\alias{extent,LAS-method}
\alias{extent,LASheader-method}
\alias{extent,LAScatalog-method}
\alias{extent,LAScluster-method}
\alias{ext,LAS-method}
\alias{ext,LASheader-method}
\alias{ext,LAScatalog-method}
\alias{ext,LAScluster-method}
\alias{bbox,LAS-method}
\alias{bbox,LASheader-method}
\alias{bbox,LAScatalog-method}
\alias{bbox,LAScluster-method}
\title{Bounding box of a LAS* object}
\usage{
\method{st_bbox}{LAS}(obj, ...)

\method{st_bbox}{LASheader}(obj, ...)

\method{st_bbox}{LAScatalog}(obj, ...)

\method{st_bbox}{LAScluster}(obj, ...)

\S4method{extent}{LAS}(x, ...)

\S4method{extent}{LASheader}(x, ...)

\S4method{extent}{LAScatalog}(x, ...)

\S4method{extent}{LAScluster}(x, ...)

\S4method{ext}{LAS}(x, ...)

\S4method{ext}{LASheader}(x, ...)

\S4method{ext}{LAScatalog}(x, ...)

\S4method{ext}{LAScluster}(x, ...)

\S4method{bbox}{LAS}(obj)

\S4method{bbox}{LASheader}(obj)

\S4method{bbox}{LAScatalog}(obj)

\S4method{bbox}{LAScluster}(obj)
}
\arguments{
\item{obj, x}{An object of class \code{LAS*}.}

\item{...}{unused}
}
\value{
A \code{bbox} from sf, an \code{Extent} from raster, a \code{matrix} from sp, or a \code{SpatExtent} from \code{terra}.
}
\description{
Bounding box of a \verb{LAS*} object. \code{st_bbox()} extends \code{sf}, \code{extent()} extends
\code{raster}, \code{bbox()} extends \code{sp}, and \code{ext()} extends \code{terra}. The values returned are similar to their
parent functions.
}
\examples{
f <- system.file("extdata", "example.las", package="rlas")
las <- readLAS(f)

st_bbox(las)
bbox(las)
extent(las)
ext(las)
}
