#' @name chmchablais3
#' 
#' @title Canopy height model (Chablais 3 plot)
#' 
#' @description Canopy height model computed from airborne laser scanning data acquired in July 2010.
#' 
#' @docType data
#'
#' @usage data(chmchablais3)
#'
#' @format A raster object
#'
#' @keywords datasets
#'
#' @references Monnet, J.-M. 2011. Using airborne laser scanning for mountain forests mapping: Support vector regression for stand parameters estimation and unsupervised training for treetop detection. Ph.D. thesis. University of Grenoble, France. pp. 21-22 & 34 \url{https://tel.archives-ouvertes.fr/tel-00652698/document}
#'
#' @examples
#' data(chmchablais3)
#' chmchablais3
#' raster::plot(chmchablais3)
NULL
"chmchablais3"
