% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{plot_tree_inventory}
\alias{plot_tree_inventory}
\title{Displays a map of tree inventory data}
\usage{
plot_tree_inventory(xy, height = NULL, diam = NULL, species = NULL, ...)
}
\arguments{
\item{xy}{data.frame. contains two columns with the X, Y  coordinates of tree
centers}

\item{height}{vector.  tree heights in meters}

\item{diam}{vector. tree diameters in centimeters}

\item{species}{vector. species abbreviation as in \code{\link{species_color}} 
for display with corresponding color}

\item{...}{Arguments to be passed to methods, as in \code{\link[graphics]{plot}}}
}
\value{
no return
}
\description{
displays tree inventory data
}
\examples{
# load tree inventory data from plot Chablais 3
data("tree_inventory_chablais3")

# display tree inventory
plot_tree_inventory(tree_inventory_chablais3[, c("x", "y")],
  diam = tree_inventory_chablais3$d, col = "red",
  pch = tree_inventory_chablais3$e,
  xlab = "X", ylab = "Y"
)

# display tree inventory with CHM background
data("chm_chablais3")
chm_chablais3 <- terra::rast(chm_chablais3)
terra::plot(chm_chablais3, col = gray(seq(0, 1, 1 / 255)))
plot_tree_inventory(tree_inventory_chablais3[, c("x", "y")],
  height = tree_inventory_chablais3$h,
  species = tree_inventory_chablais3$s,
  add = TRUE
)
}
\seealso{
\code{\link{species_color}} for a table of species and associated colors
}
