% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba.R
\name{boxcox_itr_bias_cor}
\alias{boxcox_itr_bias_cor}
\title{Inverse Box-Cox transformation with bias correction}
\usage{
boxcox_itr_bias_cor(x, lambda, varmod)
}
\arguments{
\item{x}{vector or raster values to be transformed}

\item{lambda}{numeric. parameter of Box-Cox transformation}

\item{varmod}{numeric. model residuals variance}
}
\value{
a vector or raster
}
\description{
Inverse Box-Cox transform with bias correction as suggested by Pu & Tiefelsdorf
(2015). Here `varmod` is not the local prediction variance as suggested in
the paper but the model residuals variance. For variance computation,
uses `n-p` instead of `n-1`, with `p` the number of variables in the model.
}
\examples{
x <- 1:10
boxcox_itr(x, 0.3)
boxcox_itr_bias_cor(x, 0.3, 0)
boxcox_itr_bias_cor(x, 0.3, 2)

# plot functions
curve(boxcox_itr(x, 0.3), 0, 3,
  col = "blue",
  main = "inverse Box Cox transf., lambda = 0.3",
  xlab = "x", ylab = "inverse Boxcox(x, lambda = 0.3)"
)
curve(boxcox_itr_bias_cor(x, 0.3, 1), 0, 3, col = "red", add = TRUE)
curve(boxcox_itr_bias_cor(x, 0.3, 2), 0, 3, col = "black", add = TRUE)
legend("topleft",
  legend = c(
    "residuals variance  = 2",
    "residuals variance  = 1", "residuals variance not accounted for"
  ),
  col = c("black", "red", "blue"), lty = 1
)
}
\references{
Xiaojun Pu and Michael Tiefelsdorf, 2015. A variance-stabilizing
transformation to mitigate biased variogram estimation in heterogeneous
surfaces with clustered samples. \doi{10.1007/978-3-319-22786-3_24}
}
\seealso{
\code{\link{boxcox_tr}} Box-Cox transformation,
\code{\link{boxcox_itr}} inverse Box-Cox transformation.
}
