% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coregistration.R
\name{raster_local_max}
\alias{raster_local_max}
\title{Statistics of raster local maximum}
\usage{
raster_local_max(r, dm = 2, med1 = 1, med2 = 2, quanta = 0.75, quantb = 0.5)
}
\arguments{
\item{r}{SpatRaster. typically output of \code{\link{rasters_moving_cor}}}

\item{dm}{numeric. minimum distance between two local maxima in meters}

\item{med1}{numeric. window radius to compute median value around the maximum 
position (default: 1m)}

\item{med2}{numeric. window radius #2 to compute median value around the 
maximum position (default: 2m)}

\item{quanta}{numeric. quantile value to compute for raster values (default: 
3rd quartile)}

\item{quantb}{numeric. quantile #2 value to compute for raster values 
(default: median)}
}
\value{
A data.frame with value of maximum, position of maximum, position of 
second maximum, ratio of max value to 2nd max, ratio of max value to median 
of neighborhood (size1 and size 2), ratio of max value to raster quantiles 1 
and 2
}
\description{
identifies global maximum and second global maximum from raster (e.g. output 
from \code{\link{rasters_moving_cor}}), and computes related statistics. Local 
maxima can be excluded based on a minimum distance \code{dm} to nearest local 
maximum.
}
\examples{
# create raster
r_b <- terra::rast(xmin = 0, xmax = 40, ymin =0 , ymax = 40,
resolution = 1, crs = NA)
xy <- terra::xyFromCell(r_b, 1:(nrow(r_b) * ncol(r_b)))

# add Gaussian surfaces
z1 <- 1.5 * exp(-((xy[, 1] - 22)^2 + (xy[, 2] - 22)^2 / 2) / 5)
z2 <- exp(-((xy[, 1] - 20)^2 + (xy[, 2] - 22)^2 / 2) / 3)
z3 <- 1.5 * exp(-((xy[, 1] - 17)^2 + (xy[, 2] - 17)^2 / 2) / 5)
r_b <- terra::rast(cbind(xy, z1 + z2 + z3), type = "xyz")

# create small raster
r_s <- terra::crop(r_b, terra::ext(c(15, 25, 15, 25)))
# offset raster by (-2, -2)
terra::ext(r_s) <- c(13, 23, 13, 23)

rr <- rasters_moving_cor(r_b, r_s, buffer = 6, step = 1)
loc_max <- raster_local_max(rr)
loc_max

# plot raster
terra::plot(rr)
# add location of two local maxima
graphics::points(loc_max[1, c("dx1", "dx2")], loc_max[1, c("dy1", "dy2")],
  cex = c(1, 0.5), pch = 3
)
}
\seealso{
\code{\link{rasters_moving_cor}}, \code{\link{coregistration}} for 
application to the coregistration of tree inventory data with canopy height 
models
}
