% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/charting.R
\name{fit_chart}
\alias{fit_chart}
\title{fit_chart}
\usage{
fit_chart(
  model = NULL,
  decomp_list = NULL,
  pool = NULL,
  verbose = FALSE,
  colors = NULL
)
}
\arguments{
\item{model}{Model object}

\item{decomp_list}{list object generated by the \code{decomping} function.}

\item{pool}{string specifying a group within the pool column to be filtered}

\item{verbose}{A boolean to specify whether to print warnings}

\item{colors}{character vector of colors in hexadecimal notation}
}
\value{
a \code{plotly} line chart of the model's prediction and actual
}
\description{
Dependent Variable, Predictions and Residuals Line Chart
}
\details{
Plot the dependent variable, predictions and Residuals as a line chart over the id variable which can be supplied to the \code{decomping} function.
}
\examples{
run_model(data = mtcars,dv = 'mpg',ivs = 'cyl') \%>\% fit_chart()
}
