% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqGPlikelihoods.R
\name{logLikGrad}
\alias{logLikGrad}
\title{Gradient of the Log-Likelihood of a Gaussian Process.}
\usage{
logLikGrad(
  par = model$kernParam$par,
  model,
  parfixed = rep(FALSE, length(par)),
  mcmc.opts = NULL,
  estim.varnoise = FALSE
)
}
\arguments{
\item{par}{the values of the covariance parameters.}

\item{model}{an object with \code{"lineqGP"} S3 class.}

\item{parfixed}{indices of fixed parameters to do not be optimised.}

\item{mcmc.opts}{not used.}

\item{estim.varnoise}{If \code{true}, a noise variance is estimated.}
}
\value{
the gradient of the negative log-likelihood.
}
\description{
Compute the gradient of the negative log-likelihood of a Gaussian Process.
}
\references{
Rasmussen, C. E. and Williams, C. K. I. (2005),
"Gaussian Processes for Machine Learning (Adaptive Computation and Machine Learning)".
\emph{The MIT Press}.
\href{http://www.gaussianprocess.org/gpml/}{[link]}
}
\seealso{
\code{\link{logLikFun}}, \code{\link{constrlogLikFun}},
         \code{\link{constrlogLikGrad}}
}
\author{
A. F. Lopez-Lopera.
}
