% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findCommonID.R
\name{findCommonID}
\alias{findCommonID}
\title{Find individuals in common between a cross and a phenotype matrix}
\usage{
findCommonID(id1, id2)
}
\arguments{
\item{id1}{A character vector of individual IDs.  This can also be a QTL
cross object (see \code{\link[qtl]{read.cross}}), in which case
\code{\link[qtl]{getid}} is used to grab individual IDs, or a matrix or data
frame, in which case the rownames are taken to be IDs.}

\item{id2}{Like \code{id1}, can be a character vector, a cross or a
matrix/data frame.}
}
\value{
A list with three components:

First, a data frame with rows corresponding to all individuals (across the
two sets of individual IDs) and three columns: \code{indexInFirst} and
\code{indexInSecond} contain numeric indices to the locations of the
individuals within \code{cross} and \code{pheno}, and \code{inBoth} is a
logical vector to indicate which individuals appear in both crosses.  The
row names are the individual identifiers.

The second and third components are vectors of indices in \code{id1} and
\code{id2}, respectively, indicating the paired locations of the individuals
that are in common.
}
\description{
Identify which individuals are in common between a QTL mapping data set and
a matrix of phenotypes, series of genes.
}
\examples{

data(f2cross, expr1)

# align IDs
id <- findCommonID(f2cross, expr1)

# aligned data
f2cross_aligned <- f2cross[,id$first]
expr1_aligned <- expr1[id$second,]

}
\seealso{
\code{\link{calc.locallod}}, \code{\link{corbetw2mat}}
}
\author{
Karl W Broman, \email{kbroman@biostat.wisc.edu}
}
\keyword{utilities}
