% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_self.R
\name{get_self}
\alias{get_self}
\title{Get self-self distance}
\usage{
get_self(d)
}
\arguments{
\item{d}{A distance matrix}
}
\value{
A vector with all distinct individuals, with the self-self
values
}
\description{
For each individual represented in a distance matrix, pull the
self-self entry (with NAs for individuals present in only the rows
or only the columns).
}
\examples{
# align rows in the provided dataset, lineup2ex
aligned <- align_matrix_rows(lineup2ex$gastroc, lineup2ex$islet)
# find correlated columns
selected_genes <- (corr_betw_matrices(aligned[[1]], aligned[[2]], "paired") > 0.75)
# calculate correlation between rows
similarity <- corr_betw_matrices(t(lineup2ex$gastroc[,selected_genes]),
                                 t(lineup2ex$islet[,selected_genes]), "all")
# pull out the self-self similarities
self <- get_self(similarity)

}
\seealso{
\code{\link[=get_best]{get_best()}}, \code{\link[=get_2ndbest]{get_2ndbest()}}, \code{\link[=get_nonself]{get_nonself()}}
}
