% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initControls.R
\name{getparams_GRASS4W}
\alias{getparams_GRASS4W}
\title{Get 'GRASS GIS' and \code{rgrass7} parameters on 'Windows' OS}
\usage{
getparams_GRASS4W(set_default_GRASS7 = NULL, DL = "C:",
  ver_select = FALSE)
}
\arguments{
\item{set_default_GRASS7}{default = NULL forces a full search for 'GRASS GIS' binaries. You may
alternatively provide a vector containing pathes and keywords. c("C:/OSGeo4W64","grass-7.0.5","osgeo4W") is valid for a typical osgeo4w installation.}

\item{DL}{raster or sp object}

\item{ver_select}{if TRUE you must interactivley selcect between alternative installations}
}
\description{
Initialize the enviroment variables on a 'Windows' OS for using 
 'GRASS GIS' via \link{rgrass7}
}
\details{
The concept is very straightforward but for an all days usage pretty
 helpful. You need to provide a \link{raster} or a \link{sp} object. The derived properties are used to initialize a temporary but static
 \href{https://CRAN.R-project.org/package=rgrass7}{rgrass7} environment. During the rsession you will have full access to
 GRASS7 both via the wrapper package as well as the command line. getparams_GRASS4W initializes the usage of GRASS7.
}
\examples{
\dontrun{
# automatic retrieval of valid 'GRASS GIS' environment settings 
# if more than one is found the user has to choose.
getparams_GRASS4W()

# typical stand_alone installation
getparams_GRASS4W(c("C:/Program Files/GRASS GIS 7.0.5","GRASS GIS 7.0.5","NSIS"))

# typical OSGeo4W64 installation
getparams_GRASS4W(c("C:/OSGeo4W64","grass-7.0.5","osgeo4W"))
}
}
