% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkOTB.R
\name{linkOTB}
\alias{linkOTB}
\title{Locate and set up 'Orfeo ToolBox' API bindings}
\usage{
linkOTB(
  bin_OTB = NULL,
  root_OTB = NULL,
  type_OTB = NULL,
  searchLocation = NULL,
  ver_select = FALSE,
  quiet = TRUE,
  returnPaths = TRUE
)
}
\arguments{
\item{bin_OTB}{string contains path to where the otb binaries are located}

\item{root_OTB}{string provides the root folder of the \code{bin_OTB}}

\item{type_OTB}{string}

\item{searchLocation}{string hard drive letter (Windows) or mounting point (Linux) default for Windows is \code{C:}, default for Linux is \code{~}}

\item{ver_select}{Boolean, default is FALSE. If there is more than one 'OTB' installation and \code{ver_select} = TRUE the user can interactively select the preferred 'OTB' version, conversely if FALSE the latest version is automatically selected.}

\item{quiet}{Boolean  switch for suppressing messages default is TRUE}

\item{returnPaths}{Boolean, if set to FALSE the paths of the selected version are written. 
in the PATH variable only, otherwise all paths and versions of the installed OTB versions are returned.}
}
\value{
add otb paths to the environment and creates global variables path_OTB
}
\description{
Locate and set up  \href{https://www.orfeo-toolbox.org/}{'Orfeo ToolBox'} API bindings
}
\details{
It looks for the \code{otb_cli.bat} file. If the file is found in a \code{bin} folder it is assumed to be a valid 'OTB' binary installation.

if called without any parameter \code{linkOTB()} it performs a full search over the hard drive \code{C:}. If it finds one or more 'OTB' binaries it will take the first hit. You have to set \code{ver_select = TRUE} for an interactive selection of the preferred version.
}
\note{
You may also set the path manually. Using a 'OSGeo4W64' \url{https://trac.osgeo.org/osgeo4w/} installation it is typically \code{C:/OSGeo4W64/bin/}
}
\examples{
\dontrun{
# call if you do not have any idea if and where OTB is installed
otb<-linkOTB()
if (otb$exist) {
# call it for a default OSGeo4W installation of the OTB
print(otb)
}
}
}
\author{
Chris Reudenbach
}
