\name{getOCG.clusters}
\alias{getOCG.clusters}

\title{
Generate Overlapping Cluster Generator (OCG) Communities
}
\description{
This function generates communities based on the OCG algorithm.
}
\usage{
getOCG.clusters(network, init.class.sys = 3, fusion.method = 0, max.class.card = 0, 
                cent.class.sys = 1, min.class = 2, verbose = TRUE, keep.out = FALSE)
}

\arguments{
  \item{network}{
Either a character string naming the file containing the network as an edge list, or a data frame/matrix object containing the edge list.
}
  \item{init.class.sys}{
An integer number specifying the Initial Class System: 1 - Maximal Cliques, 2 - Edges, or 3 - Centered Cliques. Defaults to 3.
}
  \item{fusion.method}{
A binary value specifying the fusion method: 0 - Fusion according to the average gain, or 2 - Fusion according to the total gain. Defaults to 0.
}
  \item{max.class.card}{
An integer number specifying the maximum allowed class cardinality. Defaults to 0, which indicates no constraint.
}
  \item{cent.class.sys}{
A binary value indicating the choice of class system for centered cliques: 0 - Final class system, needs the expected minimum number of clusters and the maximum caldinality of the final clusters, or 1 - the class system that maximizes modularity. Defaults to 1.
}
  \item{min.class}{
An integer number specifying the minimum number of expected classes. Defaults to 2.
}
  \item{verbose}{
Logical, whether to display progress of the algorithm to the screen.
}
  \item{keep.out}{
Logical, whether to keep the OCG partition intermediate file on disk or not. Defaults to FALSE.
}
}

\value{
An object of class \code{OCG}, which is a list containing the following elements:
\item{numbers }{An integer vector with the number of edges, nodes, and communities.}
\item{modularity }{An integer number specifying the modularity of the network.}
\item{Q }{A real number specifying the value of Q generated by the OCG algorithm.}
\item{nodeclusters }{A data frame consisting of 2 columns; the first contains node names, and the second contains single community IDs for each node. All communities and their nodes are represented, but not necessarily all nodes.}
\item{numclusters }{A named integer vector. Names are node names and integer values are the number of communities to which each node belongs.}
\item{igraph }{An object of class \code{\link{igraph}}. The network is represented here as an \code{igraph} object.}
\item{edgelist }{A character matrix with 2 columns containing the nodes that interact with each other.}
\item{clustsizes }{A named integer vector. Names are community IDs and integer values indicate the number of nodes that belong in each community.}
}
\references{
Becker, E., Robisson, B., Chapple, C.E., Guenoche, A. and Brun, C. (2012) Multifunctional proteins revealed by overlapping clustering in protein interaction network. \emph{Bioinformatics} \bold{28}, 84-90.
}
\author{
Alain Guenoche (main algorithm), and ported into \R by Alex T. Kalinka \email{alex.t.kalinka@gmail.com}
}

\examples{
## Generate graph and extract OCG communities.
g <- swiss[,3:4]
oc <- getOCG.clusters(g)
}

