% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R
\name{db_create_queue}
\alias{db_create_queue}
\title{Create a queue}
\usage{
db_create_queue(name, db, crash_strategy)
}
\arguments{
\item{name}{Name of the queue. If not specified or \code{NULL}, a
name is generated randomly.}

\item{db}{Path to the database file.}

\item{crash_strategy}{What to do with crashed jobs. The default is that
they will \code{"fail"} (just like a negative acknowledgement). Another
possibility is \code{"requeue"}, in which case they are requeued
immediately, potentially even multiple times. Alternatively it can be
a number, in which case they are requeued at most the specified number
of times.}
}
\description{
The database columns:
\itemize{
\item id Id of the message, it is generated automatically by the database.
\item title The title of the message, can be empty. In the future,
it can be used to filter messages.
\item message The message, arbitrary text, can be empty.
\item status Can be:
\itemize{
\item \code{READY}, ready to be consumed
\item \code{WORKING}, it is being consumed
\item \code{FAILED}, failed.
}
\item requeued How many times the message was requeued.
}
}
\keyword{internal}
