% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{trimean}
\alias{trimean}
\alias{trimean.default}
\title{Tukey's Trimean}
\usage{
trimean(x, ...)

\method{trimean}{default}(x, ...)
}
\arguments{
\item{x}{numeric vector}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
trimean (numeric value of length 1).
}
\description{
Robust centrality measure estimated as the weighted average of 
the three quartiles: \eqn{(Q_1 + 2Q_2 + Q_3) / 4}, where
\eqn{Q_1, Q_2} and \eqn{Q_3} are the first, second and third
quartiles respectively.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Tukey's trimean
}}

\examples{
stopifnot(trimean(0:100) == mean(0:100))
stopifnot(trimean(0:100) == median(0:100))

}
\references{
\url{https://en.wikipedia.org/wiki/Trimean}
}
