% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{create_logger}
\alias{create_logger}
\title{Simple Logger}
\usage{
create_logger(con = stdout(), level = c("DEBUG", "INFO", "WARNING", "ERROR"))
}
\arguments{
\item{con}{\link{connection} to write logging data to}

\item{level}{log only events of this level and those 
that are more specific (see details)}
}
\value{
Anonymous logging functions
}
\description{
Logger, in the spirit of loggers like log4j. Implemented logging
levels are DEBUG, INFO, WARNING, ERROR (in increasing order of
specificity. Logging events can be filtered to show only
events with a minimum specificity.
}
\examples{

logger <- create_logger(level = "INFO")
logger$info("starting specific computation")
logger$info("Today is {Sys.Date()}")
}
