\name{summary.liu}
\alias{summary.liu}
\alias{print.summary.liu}

\title{Summarizing Linear Liu Regression Fits}

\description{The \code{summary} method for class "liu" for scalar or vector biasing parameter \eqn{d}{d}.}

\usage{
\method{summary}{liu}(object, \dots)
\method{print}{summary.liu}(x, digits = max(4, getOption("digits") - 3),
           signif.stars = getOption("show.signif.stars"), \dots)
}

\arguments{
  \item{object}{An "liu" object, typically generated by a call to \code{liu}.}
  \item{x}{An object of class \code{summary.liu} for the \code{print.summary.liu}.}
  \item{signif.stars}{logical: if \code{TRUE}, \emph{p}-values are additionally encoded visually as \code{significance starts} in order to help scanning of long coefficient tables. It default to the \code{show.signif.stars} slot of \code{options}.}
  \item{digits}{The number of significant digits to use when printing.}
  \item{\dots}{Not presently used in this implementation.}
}

\details{\code{print.summary.liu} tries to be smart about formatting the coefficients, standard errors etc. and additionally gives 'significance stars' if \code{signif.stars} is \code{TRUE}.}

\value{
The function \code{summary} computes and returns a list of summary statistics of the fitted linear Liu regression model for scalar or vector value biasing parameter \eqn{d}{d} given as argument in \code{liu} function.
\item{coefficients}{a \eqn{p \times 5}{p * 5} matrix with columns for the scaled estimated, descaled estimated coefficients, scaled standard error, scaled \emph{t}-statistics, and corresponding \emph{p}-value (two-tailed). The Intercept term is computed by the relation \eqn{\hat{\beta}_{od}=\overline{y}-\sum_{j=1}^(p)\overline{X}_j \hat{\beta}_{jd}}{\hat{\beta}_{0d}=ybar-\sum_{j=1}^p(Xbar_j \hat{\beta}_{jd})}. The standard error of intercept term is computed as, \eqn{SE(\hat{\beta}_{0d})=\sqrt{Var(\overline{y}) +\overline{X}_j^2 diag[Cov(\hat{\beta}_{jd})]}}{SE(\hat{\beta}_{0d})=\sqrt{Var(ybar)+Xbar_j^2 diag[Cov(\hat{\beta}_{jd})]}}.}
\item{stats}{Liu related statistics of \emph{R}-squared, adjusted \emph{R}-squared, \emph{F}-statistics for testing of coefficients, AIC and BIC values for given biasing parameter \eqn{d}{d}.}
\item{rmse1}{Minimum MSE value for given biasing parameter \eqn{d}{d}.}
\item{rmse2}{Value of \eqn{d}{d} at which MSE is minimum.}
}

\references{
Aslam, M. (2014). Using Heteroscedasticity-Consistent Standard Errors for the Linear Regression Model with Correlated Regressors. \emph{Communication in Statistics-Simulation and Computation}, \strong{43}, 2353--2373.

Cule, E. and De lorio, M. (2012). A semi-Automatic method to guide the choice of ridge parameter in ridge regression.  \emph{arXiv:1205.0686v1 [stat.AP]}.

Halawa, A. And El-Bassiouni, M. (2000). Tests of Regression Coefficients Under Ridge Regression Models. \emph{Journal of Statistical Computation and Simulation}, \strong{65}, 341--356.

Hastie, T. and Tibshirani, R. (1990). \emph{Generalized Additive Models}. Chapman & Hall.

Imdadullah, M. (2017). \emph{Addressing Linear Regression Models with Correlated Regressors: Some Package Development in R}, Submitted Ph.D. thesis, Department of Statistics, Bahauddin Zakaraiya University, Multan, Pakistan.
}

\author{Muhammad Imdadullah, Dr. Muhammad Aslam}

\seealso{The Liu model fitting \code{\link{liu}}, Liu residual \code{\link{residuals}}, Liu predicted value \code{\link{predict}}}

\examples{
mod <- liu(y~., as.data.frame(Hald), d=c(-2, -1.47218, 0, 0.5, 1) )
summary(mod)
## coefficients for first biasing parameter
summary(mod)$summaries[[1]]$coefficients
summary(mod)$summaries[[1]][[1]]
## Liu related statistics from summary function
summary(mod)$summaries[[1]]$stats
}

\keyword{Testing of Liu coefficient}
