% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtl.analysis.R
\name{qtl.analysis}
\alias{qtl.analysis}
\title{Performs a balanced population QTL mapping analysis.}
\usage{
qtl.analysis(crossobj = crossobj, trait = "pred", step, method,
       threshold,distance,cofactors, window.size = 50)
}
\arguments{
\item{crossobj}{An object of class = cross obtained from the qtl.cross
function from this package, or the read.cross function from r/qtl package
(Broman and Sen, 2009).This file contains phenotypic means, genotypic
marker score, and genetic map data.}

\item{trait}{Column name for the phenotypic trait to be analyzed.}

\item{step}{Maximum distance (in cM) between positions at which the genotype
probabilities are calculated, though for step = 0, probabilities are
calculated only at the marker locations.}

\item{method}{"SIM" or "CIM" for simple interval (SIM) or
composite interval mapping (CIM).}

\item{threshold}{Threshold cut-of for multi-comparison correction.
Value could be either a set threshold or "Li&Ji". If a fixed threshold is
desired, a numerical value representing the alpha level should be indicated.
If the threshold is set to "Li&Ji", the threshold is estimated through a
bonferroni correction based on the effective number of markers
(Li and Ji, 2005). The effective number of markers is calculated based on a
singular value decomposition of the molecular marker matrix and the
Tracy-Widom statistic (Li and Ji, 2005).}

\item{distance}{To avoid co-linearity, nearby markers are not allowed in the
same model. This is the minimum distance within which two markers are
allowed to stay in the model.}

\item{cofactors}{Vector of genetic predictors to be used as cofactors.}

\item{window.size}{To avoid co-linearity, marker cofactors close to the
markers being tested are not allowed in the model. This is the minimum
distance to allow a co-factor when testing for a specific marker. Given the
resolution of common QTL studies, it is recommended to use a large
window.size (i.e. 50 cM). The default is set to 50 cM.}
}
\value{
A list of two elements: all, a data-frame containing the markers,
map positions, and p-values from the marker-trait test for association for
all markers in the data-set; and selected, a data-frame containing selected
markers (i.e. putative QTL, selected based on their p-value), their map
position, and the p-values from the marker-trait test for association.
This is also written as a report to qtl_reports.
A profile-plot is created showing the -log(p-value) against the map position.
}
\description{
Performs a balanced population QTL mapping analysis through
marker-regression (Haley and Knott 1992; Martinez and Curnow 1992).
This function could use any of the following populations: double haploid,
F2, recombinant inbred lines, back-cross, and 4-way crosses.
Performs a Single Marker Analysis, a Single Interval Mapping, or a Composite
Interval Mapping analysis, and then constructs a final model with of
relevant QTL. This function is for single environment single trait QTL
mapping.
}
\details{
"SIM" or "CIM" could be perform.
}
\note{
For multi-trait or multi-environment see qtl.memq
}
\examples{
data (DHpop_pheno)
data (DHpop_geno)
data (DHpop_map)

G.data <- DHpop_geno
map.data <- DHpop_map
P.data <- DHpop_pheno

cross.data <- qtl.cross (P.data, G.data, map.data, cross='dh',
                         heterozygotes=FALSE)

summary (cross.data)

\dontrun{
QTL_SMA
QTL.result <- qtl.analysis (crossobj=cross.data,step=0,
method='SIM', trait="height", threshold="Li&Ji", distance=30, cofactors=NULL,
window.size=30)
}

# QTL_SIM
QTL.result <- qtl.analysis ( crossobj=cross.data, step=5,
method='SIM',trait="height", threshold="Li&Ji",
distance=30,cofactors=NULL,window.size=30)

# QTL CIM
cofactors <- as.vector (QTL.result$selected$marker)

QTL.result <- qtl.analysis ( crossobj=cross.data, step=5,
method='CIM', trait="height", threshold="Li&Ji", distance=30,
cofactors=cofactors, window.size=30)

}
\author{
Lucia Gutierrez
}
\references{
Broman KW, Sen S (2009) A Guide to QTL Mapping with R/qtl.
           Springer, New York
           Haley CS, Knott SA (1992) A simple regression method for mapping
           quantitative trait loci in line crosses using flanking markers.
           Heredity, 69: 315-324
           Li J, Ji L (2005) Adjusting multiple testing in multilocus
           analyses using the eigenvalues of a correlation matrix.
           Heredity, 95: 221-227.
           Martinez O, Curnow RN (1992) Estimating the locations and the
           sizes of the effects of quantitative trait loci using flanking
           markers. Theoretical and Applied Genetics 85(4): 480-488
}
\seealso{
qtl.cross mq.diagnostics and pq.diagnostics
}

