% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_lme4.R, R/bootstrap_nlme.R, R/generics.R
\name{bootstrap.lmerMod}
\alias{bootstrap}
\alias{bootstrap.lme}
\alias{bootstrap.lmerMod}
\title{Bootstrap Nested Linear Mixed-Effects Models}
\usage{
\method{bootstrap}{lmerMod}(model, fn, type, B, resample, reb_type)

\method{bootstrap}{lme}(model, fn, type, B, resample, reb_type)

bootstrap(model, fn, type, B, resample = NULL, reb_type = NULL)
}
\arguments{
\item{model}{The model object you wish to bootstrap.}

\item{fn}{A function returning the statistic(s) of interest.}

\item{type}{A character string indicating the type of bootstrap that is being
requested. Possible values are \code{"parametric"}, \code{"residual"}, 
\code{"case"}, \code{"cgr"}, or \code{"reb"} (random effect block bootstrap).}

\item{B}{The number of bootstrap resamples.}

\item{resample}{A logical vector specifying whether each level of the model 
should be resampled in the cases bootsrap. The levels should be specified 
from the highest level (largest cluster) of the hierarchy to the lowest 
(observation-level); for example for students within a school, specify the 
school level first, then the student level.}

\item{reb_type}{Specification of what random effect block bootstrap version to
implement. Possible values are \code{0}, \code{1} or \code{2}.}
}
\value{
The returned value is an object of class "boot", compatible with the \pkg{boot}
package's \code{\link[boot]{boot}} methods.
}
\description{
Perform various bootstrap process for nested linear mixed effects (LMEs) models including:
parametric, residual, cases, CGR, and REB bootstraps.
}
\details{
All of the below methods have been implemented for nested linear mixed-effects
models fit by \code{lmer} (i.e., an \code{lmerMod} object) and \code{lme} 
(i.e., an \code{lmerMod} object). Details of the bootstrap procedures can be found
in the help file for that specific function.
}
\examples{
library(lme4) 
vcmodA <- lmer(mathAge11 ~ mathAge8 + gender + class + (1 | school), data = jsp728)

## you can write your own function to return stats, or use something like 'fixef'
mySumm <- function(.) { 
  s <- getME(., "sigma")
    c(beta = getME(., "beta"), sigma = s, sig01 = unname(s * getME(., "theta"))) 
}

## running a parametric bootstrap 
boo1 <- bootstrap(model = vcmodA, fn = mySumm, type = "parametric", B = 100)

\dontrun{
## running a cases bootstrap - only resampling the schools
boo2 <- bootstrap(model = vcmodA, fn = mySumm, type = "case", B = 100, resample = c(TRUE, FALSE))

## running a cases bootstrap - resampling the schools and students within the school
boo2 <- bootstrap(model = vcmodA, fn = mySumm, type = "case", B = 100, resample = c(TRUE, FALSE))

## running a semi-parametric bootstrap
boo3 <- bootstrap(model = vcmodA, fn = mySumm, type = "cgr", B = 100)

## running a residual bootstrap
boo4 <- bootstrap(model = vcmodA, fn = mySumm, type = "residual", B = 100)

## running an REB0 bootstrap
boo5 <- bootstrap(model = vcmodA, fn = mySumm, type = "reb", B = 100, reb_typ = 0)
}

## to "look" at it you must have the 'boot' package loaded
require("boot") 
boo1

## you can extract the boostrapped values as a data frame
as.data.frame(boo1)

## bootstrap confidence intervals are easily found using 'boot.ci'
##   warnings about "Some ... intervals may be unstable" go away
##   for larger bootstrap samples
boot.ci(boo1, index = 1, type=c("norm", "basic", "perc"))
boot.ci(boo1, index = 6, type=c("norm", "basic", "perc"))

## you can also examine the bootstrap samples graphically
plot(boo1, index = 1)

}
\references{
Carpenter, J. R., Goldstein, H. and Rasbash, J. (2003) A novel bootstrap 
   procedure for assessing the relationship between class size and achievement. 
   \emph{Journal of the Royal Statistical Society. Series C (Applied Statistics)}, 
   \bold{52}, 431--443.
   
   Chambers, R. and Chandra, H. (2013) A random effect block bootstrap for 
   clustered data. \emph{Journal of Computational and Graphical Statistics}, 
   \bold{22}, 452--470.
   
   Morris, J. S. (2002) The BLUPs are not "best" when it comes to bootstrapping. 
   \emph{Statistics and Probability Letters}, \bold{56}, 425--430.
   
   Van der Leeden, R., Meijer, E. and Busing F. M. (2008) Resampling multilevel 
   models. In J. de Leeuw and E. Meijer, editors, \emph{Handbook of 
   Multilevel Analysis}, pages 401--433. New York: Springer.
}
\seealso{
\itemize{
  \item \code{\link{parametric_bootstrap}}, \code{\link{resid_bootstrap}},
     \code{\link{case_bootstrap}}, \code{\link{cgr_bootstrap}}, 
     \code{\link{reb_bootstrap}} for more details on a specific bootstrap.
  \item \code{\link[lme4]{bootMer}} in the \pkg{lme4} package for an 
     implementation of (semi-)parameteric bootstrap for mixed models.
  \item \code{\link[boot]{boot}}, \code{\link[boot]{boot.ci}}, and \code{\link[boot]{plot.boot}} 
     from the \pkg{boot} package.
}
}

