% Generated by roxygen2 (4.0.2): do not edit by hand
\name{deriv.lmmspline}
\alias{deriv.lmmspline}
\title{Derivative information for \code{lmmspline} objects}
\usage{
\method{deriv}{lmmspline}(expr, numCores, ...)
}
\arguments{
\item{expr}{An object of class \code{lmmspline}.}

\item{numCores}{alternative \code{numeric} value indicating the number of CPU cores to be used for parallelization. Default value is automatically estimated.}

\item{...}{Additional arguments which are passed to \code{deriv}.}
}
\value{
deriv returns an object of class \code{lmmspline} containing the following components:
\item{predSpline}{ \code{data.frame} containing the predicted derivative values based on the linear model object or the linear mixed effect model object.}
\item{modelsUsed}{\code{numeric} vector indicating the model used to fit the data. 0 = linear model, 1 = linear mixed effect model spline (LMMS) with defined basis ("cubic" by default), 2 = LMMS taking subject-specific random intercept, 3 = LMMS with subject specific intercept and slope.}
\item{model}{\code{list} of models used to model time profiles.}
\item{derivative}{\code{logical} value indicating if the predicted values are the derivative information.}
}
\description{
Calculates the derivative information for \code{lmmspline} objects with a \code{"p-spline"} or \code{"cubic p-spline"} basis.
}
\examples{
\dontrun{
data(kidneySimTimeGroup)
# run lmmSpline on the samples from group 1 only
G1 <- which(kidneySimTimeGroup$group=="G1")
testLMMSplineTG<- lmmSpline(data=kidneySimTimeGroup$data[G1,],
                  time=kidneySimTimeGroup$time[G1],
                  sampleID=kidneySimTimeGroup$sampleID[G1],
                  basis="p-spline")
testLMMSplineTGDeri <- deriv(testLMMSplineTG)
summary(testLMMSplineTGDeri)}
}

