% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summary.noise-methods.R
\name{summary.noise}
\alias{summary.noise}
\title{Summary of a \code{noise} Object}
\usage{
\method{summary}{noise}(object, ...)
}
\arguments{
\item{object}{An object of class \code{noise}.}

\item{...}{ignored}
}
\value{
Summary of the \code{noise} object.
}
\description{
Summarizes the \code{noise} object returned by the \code{\link{investNoise}} method.
}
\examples{
\dontrun{
data(kidneySimTimeGroup)
# running for samples in group 1
G1 <- which(kidneySimTimeGroup$group=="G1")
noiseTest<- investNoise(data=kidneySimTimeGroup$data[G1,],
                  time=kidneySimTimeGroup$time[G1],
                  sampleID=kidneySimTimeGroup$sampleID[G1])
summary(noiseTest)}
}

