\name{par2lmom}
\alias{par2lmom}
\title{Convert the Parameters of a Distribution to the L-moments}
\description{
This function converts the parameters of a distribution to the L-moment as
represented in an L-moment object. This function dispatches to \code{lmomCCC}
where CCC represents the three character distribution identifier: \code{cau},
\code{exp}, \code{gam}, \code{gev}, \code{gld}, \code{glo}, \code{gno}, \code{gpa}, \code{gum}, \code{kap}, \code{kur}, \code{ln3}, \code{nor}, \code{pe3}, \code{ray}, \code{revgum}, \code{wak}, and \code{wei}. The conversion of parameters to TL-moments (\code{\link{TLmoms}}) is not supported. Specific use of functions such as \code{lmomTLgld} or \code{lmomTLgpa} for the TL-moments of the Generalized Lambda and Generalized Pareto distributions is required.
}
\usage{
par2lmom(para)
}
\arguments{
  \item{para}{A parameter object of a distribution.}
}
\value{
  An L-moment object (an R \code{list}) is returned.
}
\author{ W.H. Asquith}
\seealso{\code{\link{lmom.ub}}, \code{\link{lmom2par}}}
\examples{
lmr      <- lmom.ub(rnorm(20))
para     <- parnor(lmr)
frompara <- par2lmom(para)
}
\keyword{distribution}
