\name{lmridge}
\alias{lmridge}
\alias{lmridge.default}
\alias{coef.lmridge}
\alias{print.lmridge}
\alias{fitted.lmridge}
\alias{lmridgeEst}

\title{Linear Ridge Regression}

\description{Fits a linear ridge regression model after scaling regressors and returns an object of class "lmridge" (by calling \code{lmridgeEst} function) designed to be used in plotting method, testing of ridge coefficients and for computation of different ridge related statistics. The ridge biasing parameter \eqn{K}{K} can be a scalar or a vector.}

\usage{lmridge(formula, data, K = 0, scaling=c("sc", "scaled", "centered"), \dots)
lmridgeEst(formula, data, K=0, scaling=c("sc", "scaled", "centered"), \dots)
\method{lmridge}{default}(formula, data, K = 0, scaling=c("sc", "scaled", "centered"), \dots)
\method{coef}{lmridge}(object, \dots)
\method{print}{lmridge}(x, digits = max(5,getOption("digits") - 5), \dots)
\method{fitted}{lmridge}(object, \dots)
}

\arguments{
\item{formula}{Standard R formula expression, that is, a symbolic representation of the model to be fitted and has form \code{response~predictors}. For further details, see \code{\link{formula}}. }
\item{data}{An optional data frame containing the variables in the model. If not found in data, the variables are taken from \code{environment(formula)}, typically the environment from which \code{lmridge} or \code{lmridgeEst} is called.}
\item{K}{Ridge biasing parameter (may be a vector).}
\item{scaling}{The method to be used to scale the predictors. The scaling option \code{"sc"} scales the predictors to correlation form, such that the correlation matrix has unit diagonal elements. \code{"scaled"} option standardizes the predictors to have zero mean and unit variance. \code{"centered"} option centers the predictors.}
\item{object}{A lmridge object, typically generated by a call to \code{lmridge} for \code{fitted.lmridge}, \code{predict.lmridge}, \code{vcov.lmridge}, \code{residuals.lmridge}, \code{infocr.lmridge}, \code{coef.lmridge}, \code{summary.lmridge} and \code{press.lmridge} functions.}
\item{x}{An object of class \code{lmridge} (for the \code{hatr.lmridge}, \code{rstats1.lmridge}, \code{rstats2.lmridge}, \code{vif.lmridge}, \code{kest.lmridge}, \code{summary.lmride}, \code{print.lmridge}, \code{print.summary.lmridge}, \code{print.klmridge}, \code{print.rstats1}, \code{print.rstats2},  and \code{plot.lmridge}, \code{bias.plot}, \code{cv.plot}, \code{info.plot}, \code{isrm.plot}, and \code{rplots.plot} functions).}
\item{digits}{Minimum number of significant digits to be used.}
\item{\dots}{Additional arguments to be passed to or from other methods.}
}

\details{
\code{lmridge} or \code{lmridgeEst} function fits in linear ridge regression after scaling the regressors and centering the response. The \code{lmridge} is default a function that calls \code{lmridgeEst} for computation of ridge coefficients and returns an object of class "lmridge" designed to be used in plotting method, testing of ridge coefficients and for computation of different ridge related statistics. If intercept is present in the model, its coefficient is not penalized. However, intercept is estimated from the relation \eqn{y=\overline{y}-\beta \overline{X}}. \code{print.lmridge} tries to be smart about formatting of ridge coefficients.}

\value{
\code{lmridge} function returns an object of class "lmridge" after calling list of named objects from \code{lmridgeEst} function:

\item{coef}{A named vector of fitted coefficients.}
\item{call}{The matched call.}
\item{Inter}{Was an intercept included?}
\item{scaling}{The scaling method used.}
\item{mf}{Actual data used.}
\item{y}{The response variable.}
\item{xs}{The scaled matrix of predictors.}
\item{xm}{The vector of means of the predictors.}
\item{terms}{The \code{\link{terms}} object used.}
\item{xscale}{Square root of sum of squared deviation from mean regarding the scaling option used in \code{lmridge} or \code{lmridgeEst} function as argument.}
\item{rfit}{The fitted value of ridge regression for given biasing parameter \eqn{K}{K}.}
\item{K}{The ridge regression biasing parameter \eqn{K}{K} which can be scalar or a vector.}
\item{d}{A vector of singular values of scaled \code{X} matrix.}
\item{div}{Eigenvalues of scaled regressors.}
\item{Z}{A list of matrix \eqn{(X'X+KI)^{-1}X'}{(X'X+KI)^{-1}X'} for further computations.}
}

\references{
Hoerl, A.E., Kennard, R.W., and Baldwin, K.F. (1975). A Simulation Study of Ridge and Other Regression Estimators. \emph{Communication in Statistics}, \strong{5}, 308-323.

Hoerl, A.E. and Kennard, R.W., (1970). Ridge Regression: Biased Estimation of Nonorthogonal Problems. \emph{Technometrics}, \strong{12}, 55-67.
}

\note{The function at the current form cannot handle missing values. The user has to take prior action with missing values before using this function.}

\author{Muhammad Imdadullah, Dr. Muhammad Aslam}

\seealso{Testing of ridge coefficient \code{\link{summary.lmridge}}}

\examples{
data(Hald)
mod<-lmridge(y~X1+X2+X3+X4, data=as.data.frame(Hald), K=seq(0, 0.1, 0.01), scaling="sc")
## Scaled Coefficients
mod$coef

## Re-Scaled Coefficients
coef(mod)

## ridge predicted values
predict(mod)

## ridge residuals
residuals(mod)

##ridge and VIF trace
plot(mod)

## ridge VIF values
vif(mod)

## ridge Var-Cov matrix
vcov(mod)

## ridge biasing parameter by researchers
kest(mod)

## ridge fitted values
fitted(mod)

## ridge statistics 1
rstats1(mod)

## ridge statistics 2
rstats2(mod)

## list of objects from lmridgeEst function
lmridgeEst(y~X1+X2+X3+X4, data=as.data.frame(Hald), K=seq(0, 0.1, 0.01), scaling="sc")
}

\keyword{Ridge Regression}
