% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.lmvar.R
\name{residuals.lmvar}
\alias{residuals.lmvar}
\title{Residuals from an 'lmvar' object}
\usage{
\method{residuals}{lmvar}(object, log = FALSE, ...)
}
\arguments{
\item{object}{Object of class 'lmvar'}

\item{log}{Boolean, specifies whether \code{object} is a fit to a response-variable \eqn{Y} or to its logarithm \eqn{\log Y}
In both cases, \code{residuals.lmvar} returns residuals for \eqn{Y} itself.}

\item{...}{For compatibility with \code{\link[stats]{residuals}} generic}
}
\value{
A numeric vector with the residual for each observation in \code{object}.
}
\description{
Calculates residuals from an 'lmvar' object. This object can be a fit to either a response vector or the
logarithm of the response vector.
}
\details{
In case \code{log = FALSE}, the residual of an observation is defined as \eqn{y - \mu}, where \eqn{y} is the value of the observation and \eqn{\mu} its expected
value.

In case \code{log = TRUE}, the residual of an observation is defined as \eqn{e^y - \mu}, where \eqn{\mu} is the expected
value of \eqn{e^y}.
}
\examples{
# As example we use the dataset 'attenu' from the library 'datasets'. The dataset contains
# the response variable 'accel' and two explanatory variables 'mag'  and 'dist'.
library(datasets)

# Create the model matrix for the expected values
X = cbind(attenu$mag, attenu$dist)
colnames(X) = c("mag", "dist")

# Create the model matrix for the standard deviations.
X_s = cbind(attenu$mag, 1 / attenu$dist)
colnames(X_s) = c("mag", "dist_inv")

# Carry out the fit
fit = lmvar(attenu$accel, X, X_s)

# Calculate the residuals
residuals(fit)
}
\seealso{
\code{\link{fitted.lmvar}} for the expected values in an object of class 'lmvar'.
}
