% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mte.R
\name{mte}
\alias{mte}
\title{Estimation of Marginal Treatment Effects (MTE)}
\usage{
mte(selection, outcome, data, method = c("localIV", "normal"),
  bw = 0.25)
}
\arguments{
\item{selection}{A formula representing the selection equation.}

\item{outcome}{A formula representing the outcome equation where the left hand side
is the observed outcome and the right hand side includes predictors of both potential
outcomes.}

\item{data}{An optional data frame, list, or environment containing the variables
in the model.}

\item{method}{How to estimate the model: either "\code{localIV}" for semiparametric local IV
or "\code{normal}" for a normal selection model.}

\item{bw}{Bandwidth used for the local polynomial regression in the local IV approach.
Default is 0.25.}
}
\value{
An object of class \code{mte}.
 \item{coefs}{A list of fitted coefficients: \code{gamma} for the treatment selection model
    (a probit model), \code{beta1} for the baseline outcome, \code{beta2} for the treated outcome,
    and \code{theta1} and \code{theta2} for the error covariances when \code{method = "normal"}.}
 \item{ps}{Estimated propensity scores.}
 \item{ps_model}{The propensity score model, an object of class \code{\link[stats]{glm}}
    if \code{method = "localIV"}, or an object of class \code{\link[sampleSelection]{selection}}
    if \code{method = "normal"}.}
 \item{Z}{The model matrix for the treatment selection equation.}
 \item{D}{The response vector for the treatment selection equation.}
 \item{X}{The model matrix for the outcome equation.}
 \item{Y}{The observed outcome.}
 \item{call}{The matched call.}
}
\description{
\code{mte} is a function that estimates MTE using either semiparametric local
instrumental variables (local IV) or a normal selection model (Heckman, Urzua, Vytlacil 2006).
The user supplies a formula for the treatment selection model, a formula for the
outcome model, and a data frame containing the variables. The function returns an
object of class \code{mte}. Observations which contain NA (either in \code{selection} or
\code{outcome}) are removed.
}
\examples{
mte_fit <- mte(selection = d ~ x + z, outcome = y ~ x, data = toydata, bw = 0.25)

summary(mte_fit$ps_model)
hist(mte_fit$ps)

}
\references{
Heckman, James J., Sergio Urzua, and Edward Vytlacil. 2006.
  "Understanding Instrumental Variables in Models with Essential Heterogeneity."
  The Review of Economics and Statistics 88:389-432.
}
