% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParLin_expectreg_homo_biv.R
\name{ParLin_expectreg_homo_biv}
\alias{ParLin_expectreg_homo_biv}
\title{Partially linear expectile regression with a homoscedastic error and
a bivariate variable in the nonparametric function}
\usage{
ParLin_expectreg_homo_biv(
  X,
  Y,
  Z,
  omega = 0.3,
  kernel = gaussK,
  grid = cbind(seq(min(Z[, 1]), max(Z[, 1]), length.out = 10), seq(min(Z[, 2]), max(Z[,
    2]), length.out = 10))
)
}
\arguments{
\item{X}{The covariates data values for the linear part (of size \eqn{n \times k}).}

\item{Y}{The response data values.}

\item{Z}{The covariates data values for the nonparametric part (of size \eqn{n \times 2}).}

\item{omega}{Numeric vector of level between 0 and 1 where 0.5 corresponds
to the mean.}

\item{kernel}{The kernel used to perform the estimation. In default setting,
\code{kernel=gaussK}. See details in \code{\link[locpol]{Kernels}}.}

\item{grid}{Matrix of evaluation points used for the nonparametric part. In default setting, a grid of 10
equispaced grid-values in each direction on the domain of the variable \code{Z}.}
}
\value{
\code{\link{ParLin_expectreg_homo_biv}} partially linear expectile estimators
assuming a homoscedastic error and a bivariate covariate in the nonparametric part,
proposed and studied by Adam and Gijbels (2021b). \code{\link{ParLin_expectreg_homo_biv}}
returns a list whose components are:
\itemize{
 \item \code{Linear} The delta estimators for the linear part
 \item \code{Nonlinear} The estimation of the nonparametric part
 according to the grid. The rows of the estimation matrix
 are the grid on the first covariate data values (i.e. \code{Z[,1]})
 and the columns the grid on the second covariate data values (i.e. \code{Z[,2]}).
}
}
\description{
Formula interface for the partially linear expectile regression
using local linear expectile estimation for a homoscedastic error and
a bivariate variable in the nonparametric function. For the nonparametric part,
the general Rule-of-Thumb bandwidth selector proposed in Adam and Gijbels (2021b)
is used. See Adam and Gijbels (2021b) for more details.
}
\examples{
library(locpol)
library(lestat)
set.seed(6)
dist <- muniformdistribution(rep(0, 2), rep(1, 2))
values<-simulate(dist,200)
Z_1<-values[,1]
Z_2<-values[,2]
Z<-rbind(Z_1,Z_2)
gamma=cbind(3,-0.4)
set.seed(7)
eta_1<-rnorm(100,0,1)
X1=(gamma\%*\%Z)+(1.5*eta_1)
set.seed(8)
eta_2<-rnorm(100,0,2)
X2=(gamma\%*\%Z)+(1.5*eta_2)
X<-rbind(X1,X2)
set.seed(9)
epsilon<-rt(100,3)
delta_true<-rbind(0,-0.8)
Y=as.numeric((t(delta_true)\%*\%X)+(0.2*exp(1.5*(gamma\%*\%Z)))+epsilon)

ParLin_expectreg_homo_biv(X=t(X),Y=Y,Z=t(Z),omega=0.1,kernel=gaussK
,grid=cbind(seq(min(Z[,1]),max(Z[,1]),length.out=10),seq(min(Z[,2]),max(Z[,2]),length.out=10)))


}
\references{
{

Adam, C. and Gijbels, I. (2021b). Partially linear expectile regression using
local polynomial fitting. In Advances in Contemporary Statistics and Econometrics:
Festschrift in Honor of Christine Thomas-Agnan, Chapter 8, pages 139–160. Springer, New York.

}
}
