% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick_peak.R
\name{quick_peak}
\alias{quick_peak}
\title{Fast peak finder in GWAS data}
\usage{
quick_peak(
  data,
  npeaks = NA,
  p_cutoff = 5e-08,
  span = 1e+06,
  min_points = 2,
  chrom = NULL,
  pos = NULL,
  p = NULL
)
}
\arguments{
\item{data}{GWAS dataset (data.frame or data.table)}

\item{npeaks}{Number of peaks to find. If set to \code{NA}, algorithm finds all
distinct peaks separated from one another by region size specified by
\code{span}.}

\item{p_cutoff}{Specifies cut-off for p-value significance above which
p-values are ignored.}

\item{span}{Minimum genomic distance between peaks (default 1 Mb)}

\item{min_points}{Minimum number of p-value significant points which must lie
within the span of a peak. This removes peaks with single or only a few low
p-value SNPs. To disable set \code{min_points} to 1 or less.}

\item{chrom}{Determines which column in \code{data} contains chromosome
information. If \code{NULL} tries to autodetect the column.}

\item{pos}{Determines which column in \code{data} contains position information.
If \code{NULL} tries to autodetect the column.}

\item{p}{Determines which column in \code{data} contains SNP p-values. If \code{NULL}
tries to autodetect the column.}
}
\value{
Vector of row indices
}
\description{
Simple but fast function for finding peaks in genome-wide association study
(GWAS) data based on setting a minimum distance between peaks.
}
\details{
This function is designed for speed. SNP p-values are filtered to only those
which are significant as specified by \code{p_cutoff}. Each peak is identified as
the SNP with the lowest p-value and then SNPs in proximity to each peak
within the distance specified by \code{span} are removed. Regions such as the HLA
whose peaks may well be broader than \code{span} may produce multiple entries.
}
