% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logic.boosting.R
\name{get.ideal.penalty}
\alias{get.ideal.penalty}
\title{Tuning the LASSO regularization parameter}
\usage{
get.ideal.penalty(
  model,
  X,
  y,
  Z = NULL,
  scoring_rule = "deviance",
  choose = "min"
)
}
\arguments{
\item{model}{A fitted \code{linear.logic} model (i.e., a model created via
\code{\link{fitLinearLogicModel}} or \code{\link{fitLinearBoostingModel}})}

\item{X}{Matrix or data frame of binary input data.
This object should correspond to the binary matrix for fitting the model.}

\item{y}{Response vector. 0-1 coding for binary outcomes.}

\item{Z}{Optional quantitative covariables supplied as a matrix or
data frame. Only used (and required) if the model was fitted using them.}

\item{scoring_rule}{The scoring rule for evaluating the validation
error and its standard error. For classification tasks, \code{"deviance"}
or \code{"Brier"} should be used.}

\item{choose}{Model selection scheme. If the model that minimizes the
validation error should be chosen, \code{choose = "min"} should be
set. Otherwise, \code{choose = "1se"} leads to simplest model in the range
of one standard error of the minimizing model.}
}
\value{
A list containing
  \item{\code{val.res}}{A data frame containing the penalties, the
  validation scores and the corresponding standard errors}
  \item{\code{best.s}}{The ideal penalty value}
}
\description{
This function takes a fitted \code{linear.logic} model and independent
validation data as input for finding the ideal LASSO complexity penalty
\code{s}.
}
