% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logic.boosting.R
\name{gxe.test.boosting}
\alias{gxe.test.boosting}
\title{Gene-environment (GxE) interaction test based on boosted linear models}
\usage{
gxe.test.boosting(model, X, y, Z)
}
\arguments{
\item{model}{A fitted \code{linear.logic} model (i.e., a model created via
\code{\link{fitLinearLogicModel}} or \code{\link{fitLinearBoostingModel}})}

\item{X}{Matrix or data frame of binary input data.
This object should correspond to the binary matrix for fitting the model.}

\item{y}{Response vector. 0-1 coding for binary outcomes.}

\item{Z}{Quantitative covariable supplied as a matrix or data frame}
}
\value{
A list containing
  \item{\code{Deviance}}{The deviance used for performing the
    likelihood-ratio test}
  \item{\code{p.value}}{The p-value of the test}
}
\description{
This function takes a fitted \code{linear.logic} model and independent test
data as input for testing if there is a general GxE interaction.
This hypothesis test is based on a likelihood-ratio test.
}
\details{
In detail, the null hypothesis
\deqn{H_0: \delta_1 = \ldots = \delta_B = 0}
using the supplied linear model
\deqn{g(E[Y]) = \beta_0 + \sum_{i=1}^B \beta_i \cdot 1[C_i] + \delta_0 \cdot E
+ \sum_{i=1}^B \delta_i \cdot 1[C_i] \cdot E}
is tested.
}
