% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.logistf.profile.r
\name{plot.logistf.profile}
\alias{plot.logistf.profile}
\title{\code{plot} Method for \code{logistf} Likelihood Profiles}
\usage{
\method{plot}{logistf.profile}(
  x,
  type = "profile",
  max1 = TRUE,
  colmain = "black",
  colimp = "gray",
  plotmain = T,
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{profile.logistf} object}

\item{type}{Type of plot: one of c("profile", "cdf", "density")}

\item{max1}{If \code{type="density"}, normalizes density to maximum 1}

\item{colmain}{Color for main profile line}

\item{colimp}{color for completed-data profile lines (for \code{logistf.profile} objects that also 
carry the \code{CLIP.profile} class attribute)}

\item{plotmain}{if \code{FALSE}, suppresses the main profile line (for \code{logistf.profile} objects that 
also carry the \code{CLIP.profile} class attribute)}

\item{ylim}{Limits for the y-axis}

\item{...}{Further arguments to be passed to \code{plot()}.}
}
\value{
The function is called for its side effects
}
\description{
Provides the plot method for objects created by \code{profile.logistf} or \code{CLIP.profile}
}
\details{
The plot method provides three types of plots (profile, CDF, and density representation of a profile 
likelihood). For objects generated by CLIP.profile, it also allows to show the completed-data 
profiles along with the pooled profile.
}
\examples{

data(sex2) 
fit<-logistf(case ~ age+oc+vic+vicl+vis+dia, data=sex2)
plot(profile(fit,variable="dia"))
plot(profile(fit,variable="dia"), "cdf")
plot(profile(fit,variable="dia"), "density")

#generate data set with NAs
freq=c(5,2,2,7,5,4)
y<-c(rep(1,freq[1]+freq[2]), rep(0,freq[3]+freq[4]), rep(1,freq[5]), rep(0,freq[6]))
x<-c(rep(1,freq[1]), rep(0,freq[2]), rep(1,freq[3]), rep(0,freq[4]), rep(NA,freq[5]),
   rep(NA,freq[6]))
toy<-data.frame(x=x,y=y)

# impute data set 5 times
set.seed(169)
toymi<-list(0)
for(i in 1:5){
   toymi[[i]]<-toy
   y1<-toymi[[i]]$y==1 & is.na(toymi[[i]]$x)
   y0<-toymi[[i]]$y==0 & is.na(toymi[[i]]$x)
   xnew1<-rbinom(sum(y1),1,freq[1]/(freq[1]+freq[2]))
   xnew0<-rbinom(sum(y0),1,freq[3]/(freq[3]+freq[4]))
   toymi[[i]]$x[y1==TRUE]<-xnew1
   toymi[[i]]$x[y0==TRUE]<-xnew0
 }
 
# logistf analyses of each imputed data set
fit.list<-lapply(1:5, function(X) logistf(data=toymi[[X]], y~x, pl=TRUE, dataout=TRUE))

# CLIP profile 
xprof<-CLIP.profile(obj=fit.list, variable="x", data=toymi, keep=TRUE)
plot(xprof)

#plot as CDF
plot(xprof, "cdf")

#plot as density
plot(xprof, "density")

}
\references{
Heinze G, Ploner M, Beyea J (2013). Confidence intervals after multiple imputation: combining 
profile likelihood information from logistic regressions. Statistics in Medicine, to appear.
}
\author{
Georg Heinze und Meinhard Ploner
}
