% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsda.R
\name{lol.project.opal}
\alias{lol.project.opal}
\title{Optimal Partial Least-Squares (OPAL)}
\usage{
lol.project.opal(X, Y, r, ...)
}
\arguments{
\item{X}{[n, d] the data with \code{n} samples in \code{d} dimensions.}

\item{Y}{[n] the labels of the samples with \code{K} unique labels.}

\item{r}{the rank of the projection.}

\item{...}{trailing args.}
}
\value{
A list containing the following:
\item{\code{A}}{\code{[d, r]} the projection matrix from \code{d} to \code{r} dimensions.}
\item{\code{ylabs}}{\code{[K]} vector containing the \code{K} unique, ordered class labels.}
\item{\code{centroids}}{\code{[K, d]} centroid matrix of the \code{K} unique, ordered classes in native \code{d} dimensions.}
\item{\code{priors}}{\code{[K]} vector containing the \code{K} prior probabilities for the unique, ordered classes.}
\item{\code{Xr}}{\code{[n, r]} the \code{n} data points in reduced dimensionality \code{r}.}
\item{\code{cr}}{\code{[K, r]} the \code{K} centroids in reduced dimensionality \code{r}.}
}
\description{
A function for implementing the Optimal Partial Least-Squares (OPAL) Algorithm, a composition of a difference of the means and PLS on the resuals of the data and the class-conditional means.
}
\section{Details}{

For more details see the help vignette:
\code{vignette("opal", package = "lolR")}
}

\examples{
library(lolR)
data <- lol.sims.rtrunk(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
model <- lol.project.opal(X=X, Y=Y, r=5)  # use pls to project into 5 dimensions
}
\author{
Eric Bridgeford
}
