% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{pbeardmake}
\alias{pbeardmake}
\alias{dbeardmake}
\alias{hbeardmake}
\alias{qbeardmake}
\title{Distribution function of the Beard-Makeham distribution}
\usage{
pbeardmake(
  q,
  rate = 1,
  shape1 = 1,
  shape2 = 1,
  lambda = 0,
  lower.tail = TRUE,
  log.p = FALSE
)

dbeardmake(x, rate = rate, shape1 = 1, shape2 = 1, lambda = 0, log = FALSE)

hbeardmake(x, rate = rate, shape1 = 1, shape2 = 1, lambda = 0, log = FALSE)

qbeardmake(p, rate = 1, shape1 = 1, shape2 = 1, lambda = 0, lower.tail = TRUE)
}
\arguments{
\item{q}{vector of quantiles.}

\item{rate}{shape parameter (\eqn{\nu})}

\item{shape1}{shape parameter (\eqn{\alpha})}

\item{shape2}{shape parameter (\eqn{\beta})}

\item{lambda}{exponential rate of the Makeham component}

\item{lower.tail}{logical; if \code{TRUE} (default), the lower tail probability \eqn{\Pr(X \leq x)} is returned.}

\item{log.p}{logical; if \code{FALSE} (default), values are returned on the probability scale.}

\item{x}{vector of quantiles.}

\item{log}{logical; if \code{FALSE} (default), return the hazard}

\item{p}{vector of probabilities.}
}
\value{
a vector of (log)-probabilities of the same length as \code{q}

a vector of (log)-density.

a vector of (log)-hazard.

a vector of quantiles
}
\description{
Distribution function of the Beard-Makeham distribution

Density function of the Beard-Makeham distribution

Hazard function of the Beard-Makeham distribution

Quantile function of the Beard-Makeham distribution
}
\keyword{internal}
