% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/northrop.R
\name{gppiece}
\alias{gppiece}
\alias{dgppiece}
\alias{pgppiece}
\alias{qgppiece}
\alias{rgppiece}
\title{Piece-wise generalized Pareto distribution}
\usage{
dgppiece(x, scale, shape, thresh, log = FALSE)

pgppiece(q, scale, shape, thresh, lower.tail = TRUE, log.p = FALSE)

qgppiece(p, scale, shape, thresh, lower.tail = TRUE, log.p = FALSE)

rgppiece(n, scale, shape, thresh)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{scale}{positive value for the first scale parameter}

\item{shape}{vector of \code{m} shape parameters}

\item{thresh}{vector of \code{m} thresholds}

\item{log, log.p}{logical; if \code{TRUE}, the values are returned on the log scale}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{\Pr[X \leq x]} otherwise, \eqn{\Pr[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{sample size}
}
\value{
a vector of quantiles (\code{qgppiece}), probabilities (\code{pgppiece}), density (\code{dgppiece}) or random number generated from the model (\code{rgppiece})
}
\description{
Density, distribution, quantile functions and random number generation from the
mixture model of Northrop and Coleman (2014), which consists of \code{m}
different generalized Pareto distributions over non-overlapping intervals
with \code{m} shape parameters and one scale parameter; the other scale parameters are
constrained so that the resulting distribution is continuous over the domain
and reduces to a generalized Pareto distribution if all of the shape parameters are equal.
}
\references{
Northrop & Coleman (2014). Improved threshold diagnostic plots for extreme value
analyses, \emph{Extremes}, \bold{17}(2), 289--303.
}
\keyword{internal}
