% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshstab.R
\name{prof_gp_scalet}
\alias{prof_gp_scalet}
\title{Profile log likelihood for the transformed scale parameter of the generalized Pareto distribution}
\usage{
prof_gp_scalet(
  mle = NULL,
  time,
  time2 = NULL,
  event = NULL,
  thresh = 0,
  ltrunc = NULL,
  rtrunc = NULL,
  type = c("right", "left", "interval", "interval2"),
  level = 0.95,
  psi = NULL,
  weights = NULL,
  confint = TRUE,
  arguments = NULL,
  ...
)
}
\arguments{
\item{mle}{an object of class \code{elife_par}}

\item{time}{excess time of the event of follow-up time, depending on the value of event}

\item{time2}{ending excess time of the interval for interval censored data only.}

\item{event}{status indicator, normally 0=alive, 1=dead. Other choices are \code{TRUE}/\code{FALSE} (\code{TRUE} for death).
For interval censored data, the status indicator is 0=right censored, 1=event at time, 2=left censored, 3=interval censored.
Although unusual, the event indicator can be omitted, in which case all subjects are assumed to have experienced an event.}

\item{thresh}{vector of thresholds}

\item{ltrunc}{lower truncation limit, default to \code{NULL}}

\item{rtrunc}{upper truncation limit, default to \code{NULL}}

\item{type}{character string specifying the type of censoring. Possible values are "\code{right}", "\code{left}", "\code{interval}", "\code{interval2}".}

\item{level}{level of the confidence interval}

\item{weights}{weights for observations}

\item{confint}{logical; if \code{TRUE} (default), return confidence intervals rather than list}

\item{arguments}{a named list specifying default arguments of the function that are common to all \code{elife} calls}

\item{...}{additional arguments for optimization, currently ignored.}
}
\value{
a confidence interval or a list with profile values
}
\description{
This internal function is used to produce threshold stability plots.
}
\keyword{internal}
