% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{pperksmake}
\alias{pperksmake}
\alias{dperksmake}
\alias{hperksmake}
\alias{qperksmake}
\title{Distribution function of the Perks-Makeham distribution}
\usage{
pperksmake(
  q,
  rate = 1,
  shape = 1,
  lambda = 0,
  lower.tail = TRUE,
  log.p = FALSE
)

dperksmake(x, rate = 1, shape = 1, lambda = 0, log = FALSE)

hperksmake(x, rate = 1, shape = 1, lambda = 0, log = FALSE)

qperksmake(p, rate = 1, shape = 1, lambda = 0, lower.tail = TRUE)
}
\arguments{
\item{q}{vector of quantiles.}

\item{rate}{rate parameter (\eqn{\nu})}

\item{shape}{shape parameter (\eqn{\alpha})}

\item{lambda}{exponential rate of the Makeham component}

\item{lower.tail}{logical; if \code{TRUE} (default), the lower tail probability \eqn{\Pr(X \leq x)} is returned.}

\item{log.p}{logical; if \code{FALSE} (default), values are returned on the probability scale.}

\item{x}{vector of quantiles.}

\item{log}{logical; if \code{FALSE} (default), return the hazard}

\item{p}{vector of probabilities.}
}
\value{
a vector of (log)-probabilities of the same length as \code{q}

a vector of (log)-density.

a vector of (log)-hazard.

vector of quantiles

a vector of quantiles
}
\description{
Distribution function of the Perks-Makeham distribution

Density function of the Perks-Makeham distribution

Hazard function of the Perks-Makeham distribution

Quantile function of the Perks-Makeham distribution
}
\keyword{internal}
