% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshstab.R
\name{tstab}
\alias{tstab}
\title{Threshold stability plots}
\usage{
tstab(
  time,
  time2 = NULL,
  event = NULL,
  thresh = 0,
  ltrunc = NULL,
  rtrunc = NULL,
  type = c("right", "left", "interval", "interval2"),
  family = c("gp", "exp"),
  method = c("wald", "profile"),
  level = 0.95,
  plot = TRUE,
  plot.type = c("base", "ggplot"),
  which.plot = c("scale", "shape"),
  weights = NULL,
  arguments = NULL,
  ...
)
}
\arguments{
\item{time}{excess time of the event of follow-up time, depending on the value of event}

\item{time2}{ending excess time of the interval for interval censored data only.}

\item{event}{status indicator, normally 0=alive, 1=dead. Other choices are \code{TRUE}/\code{FALSE} (\code{TRUE} for death).
For interval censored data, the status indicator is 0=right censored, 1=event at time, 2=left censored, 3=interval censored.
Although unusual, the event indicator can be omitted, in which case all subjects are assumed to have experienced an event.}

\item{thresh}{vector of thresholds}

\item{ltrunc}{lower truncation limit, default to \code{NULL}}

\item{rtrunc}{upper truncation limit, default to \code{NULL}}

\item{type}{character string specifying the type of censoring. Possible values are "\code{right}", "\code{left}", "\code{interval}", "\code{interval2}".}

\item{family}{string; distribution, either generalized Pareto (\code{gp}) or exponential (\code{exp})}

\item{method}{string; the type of pointwise confidence interval, either Wald (\code{wald}) or profile likelihood (\code{profile})}

\item{level}{probability level for the pointwise confidence intervals}

\item{plot}{logical; should a plot be returned alongside with the estimates? Default to \code{TRUE}}

\item{plot.type}{string; either \code{base} for base R plots or \code{ggplot} for \code{ggplot2} plots}

\item{which.plot}{string; which parameters to plot;}

\item{weights}{weights for observations}

\item{arguments}{a named list specifying default arguments of the function that are common to all \code{elife} calls}

\item{...}{additional arguments for optimization, currently ignored.}
}
\value{
an invisible list with pointwise estimates and confidence intervals for the scale and shape parameters
}
\description{
The generalized Pareto and exponential distribution
are threshold stable. This property, which is used
for extrapolation purposes, can also be used to diagnose
goodness-of-fit: we expect the parameters \eqn{\xi} and \eqn{\tilde{\sigma} = \sigma + \xi u}
to be constant over a range of thresholds. The threshold stability
plot consists in plotting maximum likelihood estimates with pointwise confidence interval.
This function handles interval truncation and right-censoring.
}
\details{
The shape estimates are constrained
}
\examples{
set.seed(1234)
n <- 100L
x <- samp_elife(n = n,
                scale = 2,
                shape = -0.2,
                lower = low <- runif(n),
                upper = upp <- runif(n, min = 3, max = 20),
                type2 = "ltrt",
                family = "gp")
tstab_plot <- tstab(time = x,
                    ltrunc = low,
                   rtrunc = upp,
                   thresh = quantile(x, seq(0, 0.5, length.out = 4)))
plot(tstab_plot, plot.type = "ggplot")
}
\seealso{
\code{tstab.gpd} from package \code{mev}, \code{gpd.fitrange} from package \code{ismev} or \code{tcplot} from package \code{evd}, among others.
}
