% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_glyphs.R
\name{make_glyphs}
\alias{make_glyphs}
\title{Make arbitrary glyphs with R graphic devices}
\usage{
make_glyphs(data, draw_fun, width = 50, height = 50, ...)
}
\arguments{
\item{data}{list where each element contains a data object used for the 
\code{draw_fun}}

\item{draw_fun}{function that draws a glyph using \R base graphics or the 
grid (including ggplot2 and lattice) engine}

\item{width}{width of each glyph in pixel}

\item{height}{height of each glyph in pixel}

\item{...}{additional arguments passed on to the \code{\link{png}} function}
}
\value{
vector with tk img object references
}
\description{
Loon's primitive glyph types are limited in terms of compound 
  shapes. With this function you can create each point glyph as a png and 
  re-import it as a tk img object to be used as point glyphs in loon. See the
  examples.
}
\examples{
\dontrun{
data(minority)
p <- l_plot(minority$long, minority$lat)

library(maps)
canada <- map("world",  "Canada", fill=TRUE, plot=FALSE)
l_map <- l_layer(p, canada, asSingleLayer=TRUE)
l_scaleto_world(p)

img <- make_glyphs(lapply(1:nrow(minority), function(i)minority[i,]), function(m) {
    par(mar=c(1,1,1,1)*.5)
    mat <- as.matrix(m[1,1:10]/max(m[1:10]))
    barplot(height = mat,
            beside = FALSE,
            ylim = c(0,1),
            axes= FALSE,
            axisnames=FALSE)
}, width=120, height=120)

l_imageviewer(img)

g <- l_glyph_add_image(p, img, "barplot")
p['glyph'] <- g


## with grid
li <- make_glyphs(runif(6), function(x) {
    if(any(x>1 | x<0))
        stop("out of range")
    pushViewport(plotViewport(unit(c(1,1,1,1)*0, "points")))
    grid.rect(gp=gpar(fill=NA))
    grid.rect(0, 0, height = unit(x, "npc"), just = c("left", "bottom"),
              gp=gpar(col=NA, fill="steelblue"))
})
}
}
