% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_hist.R
\name{l_hist}
\alias{l_hist}
\title{Create an interactive histogram}
\usage{
l_hist(x, yshows = c("frequency", "density"), showStackedColors = TRUE,
  origin = NULL, binwidth = NULL, showBinHandle = FALSE,
  xlabel = NULL, parent = NULL, ...)
}
\arguments{
\item{x}{vector with numerical data to perform the binning onx,}

\item{yshows}{one of "frequency" (default) or  "density"}

\item{showStackedColors}{if TRUE (default) then bars will be coloured according to
colours of the points; if FALSE, then the bars will be a uniform colour
except for highlighted points.}

\item{origin}{numeric scalar to define the binning origin}

\item{binwidth}{a numeric scalar to specify the binwidth
If NULL \code{binwidth} is set using David Scott's rule when \code{x} is numeric and
and using the minumum numerical difference between factor levels when \code{x}
is a factor or a character vector.}

\item{showBinHandle}{If \code{TRUE}, then an interactive "bin handle" appears on the plot
whose movement resets the \code{origin} and the \code{binwidth}.  Default is \code{FALSE}}

\item{xlabel}{label to be used on the horizontal axis. If NULL, an attempt at a meaningful label
inferred from \code{x} will be made.}

\item{parent}{parent widget path}

\item{...}{named arguments to modify the histogram plot states}
}
\value{
widget handle
}
\description{
\code{l_hist} is a generic function for creating an interactive histogram display that can be linked with
  loon's other displays
}
\details{
Note that when changing the \code{yshows} state form
  \code{'frequency'} to \code{'density'} you might have to use
  \code{\link{l_scaleto_world}} to show the complete histogram in the plotting
  region.

For more information run: \code{l_help("learn_R_display_hist")}
}
\examples{
h <- l_hist(iris$Sepal.Length)

names(h)
h["xlabel"] <- "Sepal length"
h["showOutlines"] <- FALSE

h["yshows"]
h["yshows"] <- "density"
l_scaleto_plot(h)

h["showStackedColors"] <- TRUE
h['color'] <- iris$Species
h["showStackedColors"] <- FALSE
h["showOutlines"] <- TRUE
h["showGuides"] <- TRUE

# link another plot with the previous plot
h['linkingGroup'] <- "iris_data"
h2 <- with(iris, l_hist(Petal.Width,
                        linkingGroup="iris_data",
                        showStackedColors = TRUE))


# Get an R (grid) graphics plot of the current loon plot
plot(h)
# or with more control about grid parameters
grid.loon(h)
# or to save the grid data structure (grob) for later use
hg <- loonGrob(h)

}
\seealso{
\code{\link{l_plot}}
}
