% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balanced_data.R
\name{balanced.cv.folds.from.vector}
\alias{balanced.cv.folds.from.vector}
\title{Create balanced folds for cross validation}
\usage{
balanced.cv.folds.from.vector(dat, nfolds = 10, join.all = FALSE)
}
\arguments{
\item{dat}{vectors representing data}

\item{nfolds}{number of folds to be created}

\item{join.all}{join foldids in a single vector}
}
\value{
list with given input, nfolds and result. The result is a list
matching the input with foldid attributed to each position.
}
\description{
Create balanced folds for cross validation
}
\examples{
dat <- sample(c(TRUE, FALSE), 150, replace = TRUE)
balanced.cv.folds.from.vector(dat, nfolds = 2)
balanced.cv.folds.from.vector(dat, nfolds = 10)
balanced.cv.folds.from.vector(dat, nfolds = 10, join.all = TRUE)
balanced.cv.folds.from.vector(dat[1:5], nfolds = 10) # will give a warning
balanced.cv.folds.from.vector(dat[1:10], nfolds = 10) # will give a warning
}
