% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.interaction.R
\name{plot.lori}
\alias{plot.lori}
\title{plot 2D displays of the row-column interactions}
\usage{
\method{plot}{lori}(x, axes = c(1, 2), xlim = NULL, ylim = NULL,
  invisible = c("none", "row", "col", "row.sup", "col.sup", "quali.sup"),
  choix = c("CA", "quanti.sup"), col.row = "blue", col.col = "red",
  col.row.sup = "darkblue", col.col.sup = "darkred",
  col.quali.sup = "magenta", col.quanti.sup = "blue",
  label = c("all", "none", "row", "row.sup", "col", "col.sup",
  "quali.sup"), title = NULL, palette = NULL, autoLab = c("auto",
  "yes", "no"), new.plot = FALSE, selectRow = NULL, selectCol = NULL,
  unselect = 0.7, shadowtext = FALSE, habillage = "none",
  legend = list(bty = "y", x = "topleft"), ...)
}
\arguments{
\item{x}{a lori object resulting from the lori function}

\item{axes}{a vector of integers of length two, indicating which axes to plot (c(1,2) means that the first two directions are plotted).}

\item{xlim}{a vector of length two indicating the limits of the plot abscissa.}

\item{ylim}{a vector of length two indicating the limits of the plot ordinate.}

\item{invisible}{string indicating if some points should be unlabelled ("row", "col", "row.sup", "col.sup","quali.sup")}

\item{choix}{the graph to plot ("CA" for the CA map, "quanti.sup" for the supplementary quantitative variables)}

\item{col.row}{a color for the rows points}

\item{col.col}{a color for columns points}

\item{col.row.sup}{a color for the supplementary rows points}

\item{col.col.sup}{a color for supplementary columns points}

\item{col.quali.sup}{a color for the supplementary quanlitative variables}

\item{col.quanti.sup}{a color for the supplementary quantitative variables}

\item{label}{a list of character for the elements which are labelled (by default, all the elements are labelled ("row", "row.sup", "col", "col.sup","quali.sup")}

\item{title}{string corresponding to the title of the graph you draw (by default NULL and a title is chosen)}

\item{palette}{the color palette used to draw the points. By default colors are chosen. If you want to define the colors : palette=palette(c("black","red","blue")); or you can use: palette=palette(rainbow(30)), or in black and white for example: palette=palette(gray(seq(0,.9,len=25)))}

\item{autoLab}{if autoLab="auto", autoLab is equal to "yes" if there are less than 50 elements and "no" otherwise; if "yes", the labels of the drawn elements are placed in a "good" way (can be time-consuming if many elements), and if "no" the elements are placed quickly but may overlap}

\item{new.plot}{boolean, if TRUE, a new graphical device is created}

\item{selectRow}{a selection of the rows that are drawn; see the details section}

\item{selectCol}{a selection of the columns that are drawn; see the details section}

\item{unselect}{may be either a value between 0 and 1 that gives the transparency of the unselected objects (if unselect=1 the transparceny is total and the elements are not drawn, if unselect=0 the elements are drawn as usual but without any label) or may be a color (for example unselect="grey60")}

\item{shadowtext}{boolean; if true put a shadow on the labels (rectangles are written under the labels which may lead to difficulties to modify the graph with another program)}

\item{habillage}{color the individuals among a categorical variable (give the number of the categorical supplementary variable or its name)}

\item{legend}{a list of arguments that defines the legend if needed (when individuals are drawn according to a variable); see the arguments of the function legend}

\item{...}{further arguments passed to or from other methods, such as cex, cex.main, ...}
}
\description{
plot 2D displays of the row-column interactions
}
\examples{
X = matrix(rnorm(rep(0, 15)), 5)
Y <- matrix(rpois(length(c(X)), exp(c(X))), 5)
res_lori <- lori(Y, cov=cbind(c(X),c(X)), lambda1=1, lambda2=1)
p <- plot(res_lori)
}
