% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lotri.R
\name{lotri}
\alias{lotri}
\title{Easily Specify block-diagonal matrices with lower triangular info}
\usage{
lotri(x, ..., envir = parent.frame())
}
\arguments{
\item{x}{list, matrix or expression, see details}

\item{...}{Other arguments treated as a list that will be
concatenated then reapplied to this function.}

\item{envir}{the \code{\link[base]{environment}} in which \code{expr} is to
    be evaluated.  May also be \code{NULL}, a list, a data frame,
    a pairlist or an integer as specified to \code{\link[base]{sys.call}}.}
}
\value{
named symmetric matrix useful in RxODE simulations (and
    perhaps elsewhere)
}
\description{
Easily Specify block-diagonal matrices with lower triangular info
}
\details{
This can take an R matrix, a list including matrices or
 expressions, or expressions

 Expressions can take the form

 name ~ estimate

 Or the lower triangular matrix when "adding" the names

 name1 + name2 ~ c(est1,
                   est2, est3)

 The matricies are concatenated into a block diagonal matrix, like
 \code{\link[Matrix]{bdiag}}, but allows expressions to specify
 matrices easier.
}
\examples{

## A few ways to specify the same matrix
lotri({et2 + et3 + et4 ~ c(40,
                           0.1, 20,
                           0.1, 0.1, 30)})

## You  do not need to enclose in {}
lotri(et2 + et3 + et4 ~ c(40,
                          0.1, 20,
                          0.1, 0.1, 30),
          et5 ~ 6)
## But if you do enclose in {}, you can use
## multi-line matrix specifications:

lotri({et2 + et3 + et4 ~ c(40,
                           0.1, 20,
                           0.1, 0.1, 30);
          et5 ~ 6;
          })

## You can also add lists or actual R matrices as in this example:
lotri(list(et2 + et3 + et4 ~ c(40,
                               0.1, 20,
                               0.1, 0.1, 30),
              matrix(1,dimnames=list("et5","et5"))))

## Overall this is a flexible way to specify symmetric block
## diagonal matrices.

}
\author{
Matthew L Fidler
}
