% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lqmixTC.R
\name{lqmixTC}
\alias{lqmixTC}
\title{Linear Quantile Mixture with Time-Constant (TC) Random Coefficients}
\usage{
lqmixTC(formula, randomTC, time, G, data, qtl = 0.5, eps = 10^-5,
  maxit = 1000, se = TRUE, R = 50, start = 0, parInit = list(betaf =
  NULL, betarTC = NULL, pg = NULL, scale = NULL), verbose = TRUE, ...)
}
\arguments{
\item{formula}{an object of class formula of the form y ~ x1 + x2 + ... + xp for fixed coefficients}

\item{randomTC}{a one-sided formula of the form ~ z1 + z2 + ... + zr | group. z1,.,zr denote the variables associated to the TC random coefficients (1 for the intercept), while group is the indicator for the grouping factor, i.e. the factor identifying the unit longitudinal measurements refer to}

\item{time}{a string indicating the time variable}

\item{G}{number of mixture components defining the TC random coefficients}

\item{data}{a data frame containing the variables named in formula, randomTC, and time}

\item{qtl}{quantile to be estimated}

\item{eps}{tolerance level for (relative) convergence of the EM algorithm}

\item{maxit}{maximum number of iterations for the EM algorithm}

\item{se}{standard error computation}

\item{R}{number of bootstrap samples for computing standard errors}

\item{start}{type of starting values (0 = deterministic, 1 = random, 2 = initial values in input)}

\item{parInit}{list of initial model parameters when \code{start = 2}}

\item{verbose}{if set to FALSE, no printed output is given during the function execution}

\item{...}{further arguments to be passed to of from methods}
}
\value{
Return an object of \code{\link{class}} \code{lqmix}. This is a list containing the following elements:
\item{betaf}{a vector containing fixed regression coefficients}
\item{betarTC}{a matrix containing the TC random coefficients}
\item{pg}{the prior probabilities of the finite mixture associated to TC random coefficients}
\item{scale}{the scale parameter}
\item{sigma.e}{the standard deviation of error terms}
\item{lk}{the log-likelihood}
\item{npar}{the total number of model parameters}
\item{aic}{the AIC value}
\item{bic}{the BIC value}
\item{qtl}{the estimated quantile}
\item{G}{the number of mixture components}
\item{nsbjs}{the number of subjects}
\item{nobs}{the total number of observations}
\item{se.betaf}{the standard errors for fixed regression coefficients}
\item{se.betarTC}{the standard errors for TC random coefficients}
\item{se.pg}{the standard errors for prior probabilities of the finite mixture associated to TC random coefficients}
\item{se.scale}{the standard error for the scale parameter}
\item{miss}{the missingness type}
\item{model}{the estimated model}
\item{call}{the matched call}
}
\description{
Estimate a finite mixture of linear quantile regression models with Time-Constant (TC), discrete, random coefficients.
}
\details{
The function computes ML estimates for the parameters of a linear quantile mixture model, based on TC random coefficients.
That is, a linear quantile regression model based on a finite mixture specification.
Estimates are derived by maximizing the (log-)likelihood of a Laplace regression where the location parameter is modeled as a function of fixed and TC random coefficients, as proposed by Alfo' et. al (2017).

The function requires data in long-format and two additional columns indicating the unit identifier and the time occasion.
Two formulas specify the model, namely \code{formula} and \code{formulaTC}:
\code{formula} is associated to fixed coefficients; \code{formulaTC} is associated to TC random coefficients.

The function admits the presence of missing data, both in terms of drop-outs (monotone missing data)
and intermittent missing, under a missing-at-random assumption.

If \code{se=TRUE}, standard errors based on a block bootstrap procedure are computed.
}
\examples{
outTC = lqmixTC(formula=meas~trt+time+trt:time,randomTC=~1|id,
                time="time",G=2,data=pain,se=TRUE,R=10)
}
\references{
{
  \insertRef{ref:lqmixTC}{lqmix}
}

{
  \insertRef{ref:npml1}{lqmix}
}

{
  \insertRef{ref:npml2}{lqmix}
}
}
