% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lrpower}
\alias{lrpower}
\title{Log-rank test power}
\usage{
lrpower(
  kMax = NA_integer_,
  informationRates = NA_real_,
  efficacyStopping = NA_integer_,
  futilityStopping = NA_integer_,
  criticalValues = NA_real_,
  alpha = 0.025,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  userAlphaSpending = NA_real_,
  futilityBounds = NA_real_,
  typeBetaSpending = "none",
  parameterBetaSpending = NA_real_,
  hazardRatioH0 = 1,
  allocationRatioPlanned = 1,
  accrualTime = 0L,
  accrualIntensity = 20L,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  lambda1 = 0.0309,
  lambda2 = 0.0533,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = 11.6,
  followupTime = 18,
  fixedFollowup = 0L,
  rho1 = 0,
  rho2 = 0,
  numSubintervals = 300L,
  estimateHazardRatio = 1L,
  typeOfComputation = "direct"
)
}
\arguments{
\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates in terms of number of events.
Fixed prior to the trial. Defaults to \code{(1:kMax) / kMax} if left
unspecified.}

\item{efficacyStopping}{Indicators of whether efficacy stopping is allowed
at each stage. Defaults to true if left unspecified.}

\item{futilityStopping}{Indicators of whether futility stopping is allowed
at each stage. Defaults to true if left unspecified.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{alpha}{The significance level. Defaults to 0.025.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending. Cumulative alpha
spent up to each stage.}

\item{futilityBounds}{Lower boundaries on the z-test statistic scale
for stopping for futility at stages 1, ..., kMax-1. Defaults to
\code{rep(-6, kMax-1)} if left unspecified.}

\item{typeBetaSpending}{The type of beta spending. One of the following:
"sfOF" for O'Brien-Fleming type spending function, "sfP" for Pocock type
spending function, "sfKD" for Kim & DeMets spending function,
"sfHSD" for Hwang, Shi & DeCani spending function, and "none" for no
early futility stopping. Defaults to "none".}

\item{parameterBetaSpending}{The parameter value for the beta spending.
Corresponds to rho for "sfKD", and gamma for "sfHSD".}

\item{hazardRatioH0}{Hazard ratio under the null hypothesis for the active
treatment versus control. Defaults to 1 for superiority test.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{accrualTime}{Accrual time intervals, must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities, one for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the time intervals for
the piecewise exponential survival distribution, must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{lambda1}{A vector of hazard rates for the event in each analysis
time interval by stratum for the active treatment group.}

\item{lambda2}{A vector of hazard rates for the event in each analysis
time interval by stratum for the control group.}

\item{gamma1}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the active treatment group.}

\item{gamma2}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the control group.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{rho1}{First parameter of the Fleming-Harrington family of weighted
log-rank test. Defaults to 0 for conventional log-rank test.}

\item{rho2}{Second parameter of the Fleming-Harrington family of weighted
log-rank test. Defaults to 0 for conventional log-rank test.}

\item{numSubintervals}{Number of sub-intervals to approximate the mean
and variance of the weighted log-rank test score statistic.
Defaults to 300. Specify a larger number for better approximation.}

\item{estimateHazardRatio}{Whether to estimate the hazard ratio from 
weighted Cox regression model and report the stopping boundaries on 
the hazard ratio scale.}

\item{typeOfComputation}{Whether to use the direct approximation method 
or the Schoenfeld method. Defaults to "direct". Can use "Schoenfeld" 
under proportional hazards and conventional log-rank test.}
}
\value{
A list of S3 class \code{lrpower} with 3 components:

* \code{overallResults} containing the overall rejection probability,
overall significance level, maximum and expected number of events,
maximum and expected number of dropouts, total and expected number
of subjects, maximum and expected study duration, along with
input parameters including accrual duration, followup duration,
whether a fixed follow-up is used, parameters for the FH weights,
allocation ratio, number of stages, and hazard ratio under H0.

* \code{byStageResults} containing information rates, efficacy
and futility boundaries on the Z-scale, probability for efficacy
and futility stopping at the stage, cumulative probability for
efficacy and futility stopping by the stage, cumulative alpha spent,
expected number of events, number of dropouts, number of subjects,
and expected study time, efficacy and futility boundaries on
the HR scale and on the p-value scale, information for weighted
log-rank test, hazard ratio from weighted Cox regression, and
where efficacy and futility stopping are allowed by stage.

* \code{settings} containing input parameters such as
alpha and beta spending function and parameter values,
accrual time, accrual intensity, piecewise survival time, stratum
fraction, and hazard rates for survival and dropout by group.
}
\description{
Estimates the power, stopping probabilities, and expected
sample size in a two-group survival design.
}
\examples{
# Piecewise accrual, piecewise exponential survivals, and 5\% dropout by
# the end of 1 year.

lrpower(kMax = 2, informationRates = c(0.8, 1),
        alpha = 0.025, typeAlphaSpending = "sfOF",
        allocationRatioPlanned = 1, accrualTime = seq(0, 9),
        accrualIntensity = c(26/9*seq(1, 9), 26),
        piecewiseSurvivalTime = c(0, 6),
        stratumFraction = c(0.2, 0.8),
        lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
        lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
        gamma1 = -log(1-0.05)/12,
        gamma2 = -log(1-0.05)/12, accrualDuration = 22,
        followupTime = 18, fixedFollowup = FALSE)

}
