% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getNeventsFromHazardRatio}
\alias{getNeventsFromHazardRatio}
\title{Get the required number of events from hazard ratios}
\usage{
getNeventsFromHazardRatio(
  beta = 0.2,
  kMax = 1L,
  informationRates = NA_real_,
  efficacyStopping = NA_integer_,
  futilityStopping = NA_integer_,
  criticalValues = NA_real_,
  alpha = 0.025,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  userAlphaSpending = NA_real_,
  futilityBounds = NA_real_,
  typeBetaSpending = "none",
  parameterBetaSpending = NA_real_,
  userBetaSpending = NA_real_,
  spendingTime = NA_real_,
  hazardRatioH0 = 1,
  hazardRatio = 0.5,
  allocationRatioPlanned = 1,
  rounding = 1L
)
}
\arguments{
\item{beta}{Type II error. Defaults to 0.2.}

\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates in terms of number of events.
Fixed prior to the trial. Defaults to \code{(1:kMax) / kMax} if left
unspecified.}

\item{efficacyStopping}{Indicators of whether efficacy stopping is allowed
at each stage. Defaults to true if left unspecified.}

\item{futilityStopping}{Indicators of whether futility stopping is allowed
at each stage. Defaults to true if left unspecified.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{alpha}{The significance level. Defaults to 0.025.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending. Cumulative alpha
spent up to each stage.}

\item{futilityBounds}{Lower boundaries on the z-test statistic scale
for stopping for futility at stages 1, ..., \code{kMax-1}. Defaults to
\code{rep(-6, kMax-1)} if left unspecified.}

\item{typeBetaSpending}{The type of beta spending. One of the following:
"sfOF" for O'Brien-Fleming type spending function, "sfP" for Pocock type
spending function, "sfKD" for Kim & DeMets spending function,
"sfHSD" for Hwang, Shi & DeCani spending function, "user" for
user defined spending, and "none" for no early futility stopping.
Defaults to "none".}

\item{parameterBetaSpending}{The parameter value for the beta spending.
Corresponds to rho for "sfKD", and gamma for "sfHSD".}

\item{userBetaSpending}{The user defined beta spending. Cumulative beta
spent up to each stage.}

\item{spendingTime}{A vector of length \code{kMax} for the error spending
time at each analysis. Defaults to missing, in which case, it is the
same as \code{informationRates}.}

\item{hazardRatioH0}{Hazard ratio under the null hypothesis for the active
treatment versus control. Defaults to 1 for superiority test.}

\item{hazardRatio}{Hazard ratio under the alternative hypothesis
for the active treatment versus control. Defaults to 0.5.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{rounding}{Whether to round up the number of events.
Defaults to 1 for rounding.}
}
\value{
The required number of events.
}
\description{
Obtains the required number of events given the hazard
ratios under the null and alternative hypotheses for a group
sequential design.
}
\examples{

getNeventsFromHazardRatio(
  beta = 0.2, kMax = 2, 
  informationRates = c(0.5,1), 
  alpha = 0.025, typeAlphaSpending = "sfOF",
  typeBetaSpending = "sfP", 
  hazardRatio = 0.673)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
